/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.terrain;

import com.github.stephengold.joltjni.BodyInterface;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_4076;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.physics.terrain.VxSectionPos;
import net.xmx.velthoric.physics.terrain.cache.VxTerrainShapeCache;
import net.xmx.velthoric.physics.terrain.generation.VxTerrainGenerator;
import net.xmx.velthoric.physics.terrain.job.VxTaskPriority;
import net.xmx.velthoric.physics.terrain.job.VxTerrainJobSystem;
import net.xmx.velthoric.physics.terrain.management.VxTerrainManager;
import net.xmx.velthoric.physics.terrain.management.VxTerrainTracker;
import net.xmx.velthoric.physics.terrain.storage.VxChunkDataStore;
import net.xmx.velthoric.physics.terrain.util.VxUpdateContext;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public final class VxTerrainSystem
implements Runnable {
    private final VxPhysicsWorld physicsWorld;
    private final class_3218 level;
    private final VxTerrainJobSystem jobSystem;
    private final Thread workerThread;
    private final AtomicBoolean isInitialized = new AtomicBoolean(false);
    private final VxChunkDataStore chunkDataStore;
    private final VxTerrainShapeCache shapeCache;
    private final VxTerrainGenerator terrainGenerator;
    private final VxTerrainManager terrainManager;
    private final VxTerrainTracker terrainTracker;
    private final Set<VxSectionPos> chunksToRebuild = ConcurrentHashMap.newKeySet();
    private static final ThreadLocal<VxUpdateContext> updateContext = ThreadLocal.withInitial(VxUpdateContext::new);

    public VxTerrainSystem(VxPhysicsWorld physicsWorld, class_3218 level) {
        this.physicsWorld = physicsWorld;
        this.level = level;
        this.jobSystem = new VxTerrainJobSystem();
        this.shapeCache = new VxTerrainShapeCache(2048);
        this.chunkDataStore = new VxChunkDataStore();
        this.terrainGenerator = new VxTerrainGenerator(this.shapeCache);
        this.terrainManager = new VxTerrainManager(physicsWorld, level, this.terrainGenerator, this.chunkDataStore, this.jobSystem);
        this.terrainTracker = new VxTerrainTracker(physicsWorld, this.terrainManager, this.chunkDataStore, level);
        this.workerThread = new Thread((Runnable)this, "Velthoric Terrain System - " + level.method_27983().method_29177().method_12832());
        this.workerThread.setDaemon(true);
    }

    public void initialize() {
        if (this.isInitialized.compareAndSet(false, true)) {
            this.workerThread.start();
        }
    }

    public void shutdown() {
        if (this.isInitialized.compareAndSet(true, false)) {
            this.jobSystem.shutdown();
            this.workerThread.interrupt();
            VxMainClass.LOGGER.debug("Shutting down Terrain System for '{}'. Waiting up to 30 seconds for worker thread to exit...", (Object)this.level.method_27983().method_29177());
            try {
                this.workerThread.join(30000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                VxMainClass.LOGGER.warn("Interrupted while waiting for terrain system thread to stop.");
            }
            if (this.workerThread.isAlive()) {
                StringBuilder stackTraceBuilder = new StringBuilder();
                stackTraceBuilder.append("Stack trace of deadlocked thread '").append(this.workerThread.getName()).append("':\n");
                for (StackTraceElement ste : this.workerThread.getStackTrace()) {
                    stackTraceBuilder.append("\tat ").append(ste).append("\n");
                }
                VxMainClass.LOGGER.fatal("Terrain system thread for '{}' did not terminate in 30 seconds. Forcing shutdown.\n{}", (Object)this.level.method_27983().method_29177(), (Object)stackTraceBuilder.toString());
            } else {
                VxMainClass.LOGGER.debug("Terrain system for '{}' shut down gracefully.", (Object)this.level.method_27983().method_29177());
            }
            VxMainClass.LOGGER.debug("Cleaning up terrain physics bodies for '{}'...", (Object)this.level.method_27983().method_29177());
            this.terrainManager.cleanupAllBodies();
            this.shapeCache.clear();
            this.terrainGenerator.close();
            this.chunkDataStore.clear();
            this.chunksToRebuild.clear();
            this.terrainTracker.clear();
            VxMainClass.LOGGER.debug("Terrain system for '{}' has been fully shut down.", (Object)this.level.method_27983().method_29177());
        }
    }

    @Override
    public void run() {
        while (this.isInitialized.get() && !Thread.currentThread().isInterrupted()) {
            try {
                this.terrainTracker.update();
                this.processRebuildQueue();
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            catch (Exception e) {
                VxMainClass.LOGGER.error("Error in TerrainSystem worker thread", (Throwable)e);
            }
        }
    }

    public void onBlockUpdate(class_2338 worldPos) {
        if (!this.isInitialized.get()) {
            return;
        }
        VxSectionPos pos = VxSectionPos.fromBlockPos(worldPos.method_10062());
        if (this.terrainManager.isManaged(pos)) {
            this.chunksToRebuild.add(pos);
        }
        this.physicsWorld.execute(() -> {
            BodyInterface bi = this.physicsWorld.getPhysicsSystem().getBodyInterface();
            if (bi == null) {
                return;
            }
            VxUpdateContext ctx = updateContext.get();
            ctx.vec3_1.set((float)worldPos.method_10263() - 2.0f, (float)worldPos.method_10264() - 2.0f, (float)worldPos.method_10260() - 2.0f);
            ctx.vec3_2.set((float)worldPos.method_10263() + 3.0f, (float)worldPos.method_10264() + 3.0f, (float)worldPos.method_10260() + 3.0f);
            ctx.aabox_1.setMin(ctx.vec3_1);
            ctx.aabox_1.setMax(ctx.vec3_2);
            bi.activateBodiesInAaBox(ctx.aabox_1, ctx.bplFilter, ctx.olFilter);
        });
    }

    private void processRebuildQueue() {
        if (this.chunksToRebuild.isEmpty()) {
            return;
        }
        HashSet<VxSectionPos> batch = new HashSet<VxSectionPos>(this.chunksToRebuild);
        this.chunksToRebuild.removeAll(batch);
        for (VxSectionPos pos : batch) {
            this.terrainManager.rebuildChunk(pos, VxTaskPriority.MEDIUM);
        }
    }

    public boolean isReady(VxSectionPos pos) {
        return this.terrainManager.isReady(pos);
    }

    public boolean isPlaceholder(VxSectionPos pos) {
        return this.terrainManager.isPlaceholder(pos);
    }

    public boolean isSectionReady(class_4076 sectionPos) {
        if (sectionPos == null) {
            return false;
        }
        return this.isReady(new VxSectionPos(sectionPos.method_18674(), sectionPos.method_18683(), sectionPos.method_18687()));
    }

    public boolean isTerrainBody(int bodyId) {
        if (bodyId <= 0) {
            return false;
        }
        for (int id : this.chunkDataStore.bodyIds) {
            if (id != bodyId) continue;
            return true;
        }
        return false;
    }

    public class_3218 getLevel() {
        return this.level;
    }
}

