/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.vehicle;

import com.github.stephengold.joltjni.Body;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.VehicleCollisionTester;
import com.github.stephengold.joltjni.VehicleCollisionTesterCastCylinder;
import com.github.stephengold.joltjni.VehicleConstraint;
import com.github.stephengold.joltjni.VehicleConstraintSettings;
import com.github.stephengold.joltjni.Wheel;
import com.github.stephengold.joltjni.WheelSettingsWv;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;
import net.xmx.velthoric.network.VxByteBuf;
import net.xmx.velthoric.physics.body.client.VxRenderState;
import net.xmx.velthoric.physics.body.manager.VxJoltBridge;
import net.xmx.velthoric.physics.body.manager.VxRemovalReason;
import net.xmx.velthoric.physics.body.registry.VxBodyType;
import net.xmx.velthoric.physics.body.sync.VxDataAccessor;
import net.xmx.velthoric.physics.body.sync.VxDataSerializers;
import net.xmx.velthoric.physics.body.type.VxRigidBody;
import net.xmx.velthoric.physics.mounting.VxMountable;
import net.xmx.velthoric.physics.vehicle.wheel.VxWheel;
import net.xmx.velthoric.physics.vehicle.wheel.VxWheelRenderState;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public abstract class VxVehicle
extends VxRigidBody
implements VxMountable {
    public static final VxDataAccessor<List<WheelSettingsWv>> DATA_WHEELS_SETTINGS = VxDataAccessor.create(VxVehicle.class, VxDataSerializers.WHEEL_SETTINGS_LIST);
    protected List<VxWheel> wheels = Collections.emptyList();
    protected VehicleConstraintSettings constraintSettings;
    protected VehicleCollisionTester collisionTester;
    protected VehicleConstraint constraint;
    private boolean wheelsDirty = false;
    @Environment(value=EnvType.CLIENT)
    private VxWheelRenderState[] prevWheelStates;
    @Environment(value=EnvType.CLIENT)
    private VxWheelRenderState[] targetWheelStates;
    @Environment(value=EnvType.CLIENT)
    protected List<VxWheelRenderState> interpolatedWheelStates;

    protected VxVehicle(VxBodyType<? extends VxVehicle> type, VxPhysicsWorld world, UUID id) {
        super((VxBodyType<? extends VxRigidBody>)type, world, id);
    }

    @Environment(value=EnvType.CLIENT)
    protected VxVehicle(VxBodyType<? extends VxVehicle> type, UUID id) {
        super((VxBodyType<? extends VxRigidBody>)type, id);
        this.prevWheelStates = new VxWheelRenderState[0];
        this.targetWheelStates = new VxWheelRenderState[0];
        this.interpolatedWheelStates = new ArrayList<VxWheelRenderState>();
    }

    @Override
    protected void defineSyncData() {
        this.synchronizedData.define(DATA_WHEELS_SETTINGS, Collections.emptyList());
    }

    @Override
    public void onBodyAdded(VxPhysicsWorld world) {
        super.onBodyAdded(world);
        Body body = VxJoltBridge.INSTANCE.getJoltBody(world, this.getBodyId());
        if (body == null || this.constraintSettings == null) {
            throw new IllegalStateException("Vehicle cannot be initialized without a body or constraint settings.");
        }
        this.constraint = new VehicleConstraint(body, this.constraintSettings);
        if (this.collisionTester == null) {
            this.collisionTester = new VehicleCollisionTesterCastCylinder(body.getObjectLayer());
        }
        this.constraint.setVehicleCollisionTester(this.collisionTester);
        world.getPhysicsSystem().addConstraint(this.constraint);
        world.getPhysicsSystem().addStepListener(this.constraint.getStepListener());
    }

    @Override
    public void onBodyRemoved(VxPhysicsWorld world, VxRemovalReason reason) {
        super.onBodyRemoved(world, reason);
        if (this.constraint != null) {
            world.getPhysicsSystem().removeStepListener(this.constraint.getStepListener());
            world.getPhysicsSystem().removeConstraint(this.constraint);
            this.constraint.close();
            this.constraint = null;
        }
        if (this.collisionTester != null) {
            this.collisionTester.close();
            this.collisionTester = null;
        }
    }

    @Override
    public void physicsTick(VxPhysicsWorld world) {
        super.physicsTick(world);
        if (this.constraint != null && !this.wheels.isEmpty()) {
            this.updateWheelStates();
        }
    }

    private void updateWheelStates() {
        boolean changed = false;
        for (int i = 0; i < this.wheels.size(); ++i) {
            VxWheel vxWheel = this.wheels.get(i);
            Wheel joltWheel = this.constraint.getWheel(i);
            vxWheel.setRotationAngle(joltWheel.getRotationAngle());
            vxWheel.setSteerAngle(joltWheel.getSteerAngle());
            vxWheel.setSuspensionLength(joltWheel.getSuspensionLength());
            vxWheel.setHasContact(joltWheel.hasContact());
            changed = true;
        }
        if (changed) {
            this.markWheelsDirty();
        }
    }

    @Override
    public void writePersistenceData(VxByteBuf buf) {
        DATA_WHEELS_SETTINGS.getSerializer().write(buf, this.getSyncData(DATA_WHEELS_SETTINGS));
    }

    @Override
    public void readPersistenceData(VxByteBuf buf) {
        List<WheelSettingsWv> newSettings = DATA_WHEELS_SETTINGS.getSerializer().read(buf);
        if (newSettings.size() == this.wheels.size()) {
            ArrayList<WheelSettingsWv> wheelSettingsList = new ArrayList<WheelSettingsWv>(this.wheels.size());
            for (int i = 0; i < this.wheels.size(); ++i) {
                WheelSettingsWv settings = newSettings.get(i);
                this.wheels.get(i).setSettings(settings);
                wheelSettingsList.add(settings);
            }
            this.setSyncData(DATA_WHEELS_SETTINGS, wheelSettingsList);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void updateWheelState(int wheelIndex, float rotation, float steer, float suspension) {
        if (wheelIndex < 0 || wheelIndex >= this.targetWheelStates.length) {
            return;
        }
        this.prevWheelStates[wheelIndex] = this.targetWheelStates[wheelIndex];
        this.targetWheelStates[wheelIndex] = new VxWheelRenderState(rotation, steer, suspension);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void calculateRenderState(float partialTicks, VxRenderState outState, RVec3 tempPos, Quat tempRot) {
        super.calculateRenderState(partialTicks, outState, tempPos, tempRot);
        List<WheelSettingsWv> currentWheelSettings = this.getWheelSettings();
        int wheelCount = currentWheelSettings.size();
        if (wheelCount != this.targetWheelStates.length) {
            this.prevWheelStates = new VxWheelRenderState[wheelCount];
            this.targetWheelStates = new VxWheelRenderState[wheelCount];
            this.interpolatedWheelStates.clear();
            VxWheelRenderState initial = new VxWheelRenderState(0.0f, 0.0f, 0.0f);
            for (int i = 0; i < wheelCount; ++i) {
                this.prevWheelStates[i] = initial;
                this.targetWheelStates[i] = initial;
                this.interpolatedWheelStates.add(initial);
            }
        }
        if (this.targetWheelStates.length > 0) {
            for (int i = 0; i < this.targetWheelStates.length; ++i) {
                VxWheelRenderState prev = this.prevWheelStates[i];
                VxWheelRenderState target = this.targetWheelStates[i];
                if (prev == null || target == null) continue;
                float rot = class_3532.method_16439((float)partialTicks, (float)prev.rotationAngle(), (float)target.rotationAngle());
                float steer = class_3532.method_16439((float)partialTicks, (float)prev.steerAngle(), (float)target.steerAngle());
                float susp = class_3532.method_16439((float)partialTicks, (float)prev.suspensionLength(), (float)target.suspensionLength());
                this.interpolatedWheelStates.set(i, new VxWheelRenderState(rot, steer, susp));
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public List<WheelSettingsWv> getWheelSettings() {
        return this.getSyncData(DATA_WHEELS_SETTINGS);
    }

    @Environment(value=EnvType.CLIENT)
    public List<VxWheelRenderState> getInterpolatedWheelStates() {
        return this.interpolatedWheelStates;
    }

    public void markWheelsDirty() {
        this.wheelsDirty = true;
    }

    public boolean areWheelsDirty() {
        return this.wheelsDirty;
    }

    public void clearWheelsDirty() {
        this.wheelsDirty = false;
    }

    public List<VxWheel> getWheels() {
        return this.wheels;
    }
}

