/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.vehicle.sync;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.xmx.velthoric.network.VxPacketHandler;
import net.xmx.velthoric.physics.body.manager.VxBodyManager;
import net.xmx.velthoric.physics.body.type.VxBody;
import net.xmx.velthoric.physics.vehicle.VxVehicle;
import net.xmx.velthoric.physics.vehicle.sync.S2CUpdateWheelsPacket;
import net.xmx.velthoric.physics.vehicle.wheel.VxWheel;

public class VxWheelNetworkDispatcher {
    public void dispatchUpdates(class_3218 level, VxBodyManager manager, Map<UUID, Set<class_3222>> bodyTrackers) {
        ArrayList<VxVehicle> dirtyVehicles = new ArrayList<VxVehicle>();
        for (VxBody body : manager.getAllBodies()) {
            VxVehicle vehicle;
            if (!(body instanceof VxVehicle) || !(vehicle = (VxVehicle)body).areWheelsDirty()) continue;
            dirtyVehicles.add(vehicle);
            vehicle.clearWheelsDirty();
        }
        if (dirtyVehicles.isEmpty()) {
            return;
        }
        level.method_8503().execute(() -> {
            for (VxVehicle vehicle : dirtyVehicles) {
                List<VxWheel> wheels;
                int wheelCount;
                Set trackers = (Set)bodyTrackers.get(vehicle.getPhysicsId());
                if (trackers == null || trackers.isEmpty() || (wheelCount = (wheels = vehicle.getWheels()).size()) == 0) continue;
                float[] rotations = new float[wheelCount];
                float[] steers = new float[wheelCount];
                float[] suspensions = new float[wheelCount];
                for (int i = 0; i < wheelCount; ++i) {
                    VxWheel wheel = wheels.get(i);
                    rotations[i] = wheel.getRotationAngle();
                    steers[i] = wheel.getSteerAngle();
                    suspensions[i] = wheel.getSuspensionLength();
                }
                S2CUpdateWheelsPacket packet = new S2CUpdateWheelsPacket(vehicle.getPhysicsId(), wheelCount, rotations, steers, suspensions);
                for (class_3222 player : trackers) {
                    VxPacketHandler.sendToPlayer(packet, player);
                }
            }
        });
    }
}

