/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.world;

import com.github.stephengold.joltjni.BroadPhaseLayerInterface;
import com.github.stephengold.joltjni.JobSystemThreadPool;
import com.github.stephengold.joltjni.ObjectLayerPairFilter;
import com.github.stephengold.joltjni.ObjectVsBroadPhaseLayerFilter;
import com.github.stephengold.joltjni.PhysicsSettings;
import com.github.stephengold.joltjni.PhysicsSystem;
import com.github.stephengold.joltjni.TempAllocator;
import com.github.stephengold.joltjni.TempAllocatorImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3517;
import net.minecraft.class_5321;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.natives.VxNativeJolt;
import net.xmx.velthoric.physics.body.manager.VxBodyManager;
import net.xmx.velthoric.physics.buoyancy.VxBuoyancyManager;
import net.xmx.velthoric.physics.constraint.manager.VxConstraintManager;
import net.xmx.velthoric.physics.mounting.manager.VxMountingManager;
import net.xmx.velthoric.physics.terrain.VxTerrainSystem;
import net.xmx.velthoric.physics.world.VxPauseUtil;
import net.xmx.velthoric.physics.world.pcmd.ICommand;
import net.xmx.velthoric.physics.world.pcmd.RunTaskCommand;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VxPhysicsWorld
implements Runnable,
Executor {
    private static final int SIMULATION_HZ = 60;
    private static final float FIXED_TIME_STEP = 0.016666668f;
    private static final float MAX_ACCUMULATED_TIME = 0.083333336f;
    private static final int MAX_COMMANDS_PER_TICK = 4096;
    private static final Map<class_5321<class_1937>, VxPhysicsWorld> worlds = new ConcurrentHashMap<class_5321<class_1937>, VxPhysicsWorld>();
    private final class_3218 level;
    private final class_5321<class_1937> dimensionKey;
    private final VxBodyManager bodyManager;
    private final VxConstraintManager constraintManager;
    private final VxTerrainSystem terrainSystem;
    private final VxMountingManager mountingManager;
    private final VxBuoyancyManager buoyancyManager;
    private final class_3517 physicsFrameTimer = new class_3517();
    private PhysicsSystem physicsSystem;
    private JobSystemThreadPool jobSystem;
    private TempAllocator tempAllocator;
    private final Queue<ICommand> commandQueue = new ConcurrentLinkedQueue<ICommand>();
    private volatile Thread physicsThreadExecutor;
    private volatile boolean isRunning = false;
    private float timeAccumulator = 0.0f;
    private long lastTimeNanos = 0L;

    private VxPhysicsWorld(class_3218 level) {
        this.level = level;
        this.dimensionKey = level.method_27983();
        this.bodyManager = new VxBodyManager(this);
        this.constraintManager = new VxConstraintManager(this.bodyManager);
        this.terrainSystem = new VxTerrainSystem(this, this.level);
        this.mountingManager = new VxMountingManager(this);
        this.buoyancyManager = new VxBuoyancyManager(this);
    }

    public static VxPhysicsWorld getOrCreate(class_3218 level) {
        return worlds.computeIfAbsent((class_5321<class_1937>)level.method_27983(), key -> {
            VxPhysicsWorld newWorld = new VxPhysicsWorld(level);
            newWorld.initializeAndStart();
            return newWorld;
        });
    }

    @Nullable
    public static VxPhysicsWorld get(class_5321<class_1937> dimensionKey) {
        return worlds.get(dimensionKey);
    }

    public static void shutdown(class_5321<class_1937> dimensionKey) {
        VxPhysicsWorld world = worlds.remove(dimensionKey);
        if (world != null) {
            world.stop();
        }
    }

    public static void shutdownAll() {
        new ArrayList<class_5321<class_1937>>(worlds.keySet()).forEach((Consumer<class_5321<class_1937>>)((Consumer<class_5321>)VxPhysicsWorld::shutdown));
        worlds.clear();
    }

    private void initializeAndStart() {
        if (this.physicsThreadExecutor != null && this.physicsThreadExecutor.isAlive()) {
            return;
        }
        this.bodyManager.initialize();
        this.constraintManager.initialize();
        this.terrainSystem.initialize();
        this.isRunning = true;
        String threadName = "Velthoric Physics Thread - " + this.dimensionKey.method_29177().method_12832().replace('/', '_');
        this.physicsThreadExecutor = new Thread((Runnable)this, threadName);
        this.physicsThreadExecutor.setDaemon(true);
        this.physicsThreadExecutor.start();
    }

    public void stop() {
        if (!this.isRunning) {
            return;
        }
        this.isRunning = false;
        if (this.physicsThreadExecutor != null && this.physicsThreadExecutor.isAlive()) {
            try {
                this.physicsThreadExecutor.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                VxMainClass.LOGGER.warn("The server thread was interrupted while waiting for the physics thread {} to stop completely.", (Object)this.physicsThreadExecutor.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            VxNativeJolt.initialize();
            this.initializePhysicsSystem();
            this.lastTimeNanos = System.nanoTime();
            while (this.isRunning) {
                this.processCommandQueue();
                long currentTimeNanos = System.nanoTime();
                float deltaTime = (float)(currentTimeNanos - this.lastTimeNanos) / 1.0E9f;
                this.lastTimeNanos = currentTimeNanos;
                this.updatePhysicsLoop(deltaTime);
                Thread.sleep(1L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Throwable t) {
            VxMainClass.LOGGER.fatal("Fatal error in physics loop for dimension {}", (Object)this.dimensionKey.method_29177(), (Object)t);
            this.isRunning = false;
        }
        finally {
            this.shutdownInternalSystems();
            this.cleanupJolt();
        }
    }

    private void updatePhysicsLoop(float deltaTime) {
        if (VxPauseUtil.isPaused() || !this.isRunning || this.physicsSystem == null) {
            return;
        }
        this.timeAccumulator += deltaTime;
        if (this.timeAccumulator > 0.083333336f) {
            this.timeAccumulator = 0.083333336f;
        }
        if (this.timeAccumulator >= 0.016666668f) {
            long startTime = System.nanoTime();
            int error = this.physicsSystem.update(0.016666668f, 1, this.tempAllocator, this.jobSystem);
            if (error != 0) {
                VxMainClass.LOGGER.error("Jolt physics update failed with error code: {}. Shutting down world.", (Object)error);
                this.isRunning = false;
                return;
            }
            this.onPhysicsTick();
            this.physicsFrameTimer.method_15247(System.nanoTime() - startTime);
            this.timeAccumulator -= 0.016666668f;
        }
    }

    public void onPhysicsTick() {
        this.bodyManager.onPhysicsTick(this);
        this.buoyancyManager.applyBuoyancyForces(0.016666668f);
    }

    public void onGameTick(class_3218 level) {
        this.bodyManager.onGameTick(level);
        this.mountingManager.onGameTick();
        this.buoyancyManager.updateFluidStates();
    }

    private void processCommandQueue() {
        ICommand command;
        for (int i = 0; i < 4096 && (command = this.commandQueue.poll()) != null; ++i) {
            try {
                command.execute(this);
                continue;
            }
            catch (Exception e) {
                VxMainClass.LOGGER.error("Exception while executing physics command", (Throwable)e);
            }
        }
    }

    public void initializePhysicsSystem() {
        int maxBodies = 65536;
        int maxBodyPairs = 65536;
        int maxContactConstraints = 65536;
        int numPositionIterations = 10;
        int numVelocityIterations = 15;
        float speculativeContactDistance = 0.02f;
        float baumgarteFactor = 0.2f;
        float penetrationSlop = 0.001f;
        float timeBeforeSleep = 1.0f;
        float pointVelocitySleepThreshold = 0.005f;
        float gravityY = -9.81f;
        this.tempAllocator = new TempAllocatorImpl(0x4000000);
        int numThreads = Math.max(1, Runtime.getRuntime().availableProcessors() - 2);
        this.jobSystem = new JobSystemThreadPool(2048, 8, numThreads);
        this.physicsSystem = new PhysicsSystem();
        BroadPhaseLayerInterface bpli = VxNativeJolt.getBroadPhaseLayerInterface();
        ObjectVsBroadPhaseLayerFilter ovbpf = VxNativeJolt.getObjectVsBroadPhaseLayerFilter();
        ObjectLayerPairFilter olpf = VxNativeJolt.getObjectLayerPairFilter();
        this.physicsSystem.init(65536, 0, 65536, 65536, bpli, ovbpf, olpf);
        try (PhysicsSettings settings = this.physicsSystem.getPhysicsSettings();){
            settings.setNumPositionSteps(10);
            settings.setNumVelocitySteps(15);
            settings.setSpeculativeContactDistance(0.02f);
            settings.setBaumgarte(0.2f);
            settings.setPenetrationSlop(0.001f);
            settings.setTimeBeforeSleep(1.0f);
            settings.setPointVelocitySleepThreshold(0.005f);
            settings.setDeterministicSimulation(false);
            this.physicsSystem.setPhysicsSettings(settings);
        }
        this.physicsSystem.setGravity(0.0f, -9.81f, 0.0f);
        this.physicsSystem.optimizeBroadPhase();
    }

    private void shutdownInternalSystems() {
        if (this.terrainSystem != null) {
            this.terrainSystem.shutdown();
        }
        if (this.constraintManager != null) {
            this.constraintManager.shutdown();
        }
        if (this.bodyManager != null) {
            this.bodyManager.shutdown();
        }
        if (this.buoyancyManager != null) {
            this.buoyancyManager.shutdown();
        }
    }

    private void cleanupJolt() {
        if (this.physicsSystem != null) {
            this.physicsSystem.close();
            this.physicsSystem = null;
        }
        if (this.jobSystem != null) {
            this.jobSystem.close();
            this.jobSystem = null;
        }
        if (this.tempAllocator != null) {
            this.tempAllocator.close();
            this.tempAllocator = null;
        }
        this.commandQueue.clear();
    }

    public void queueCommand(ICommand command) {
        if (command != null && this.isRunning) {
            this.commandQueue.offer(command);
        }
    }

    @Override
    public void execute(@NotNull Runnable task) {
        RunTaskCommand.queue(this, task);
    }

    public VxBodyManager getBodyManager() {
        return this.bodyManager;
    }

    public VxConstraintManager getConstraintManager() {
        return this.constraintManager;
    }

    public VxTerrainSystem getTerrainSystem() {
        return this.terrainSystem;
    }

    public VxMountingManager getMountingManager() {
        return this.mountingManager;
    }

    public VxBuoyancyManager getBuoyancyManager() {
        return this.buoyancyManager;
    }

    public class_3218 getLevel() {
        return this.level;
    }

    public class_5321<class_1937> getDimensionKey() {
        return this.dimensionKey;
    }

    public float getFixedTimeStep() {
        return 0.016666668f;
    }

    public boolean isRunning() {
        return this.isRunning && this.physicsThreadExecutor != null && this.physicsThreadExecutor.isAlive();
    }

    @Nullable
    public PhysicsSystem getPhysicsSystem() {
        return this.physicsSystem;
    }

    public class_3517 getPhysicsFrameTimer() {
        return this.physicsFrameTimer;
    }

    @Nullable
    public static VxBodyManager getBodyManager(class_5321<class_1937> dimensionKey) {
        VxPhysicsWorld world = VxPhysicsWorld.get(dimensionKey);
        return world != null ? world.getBodyManager() : null;
    }

    @Nullable
    public static VxConstraintManager getConstraintManager(class_5321<class_1937> dimensionKey) {
        VxPhysicsWorld world = VxPhysicsWorld.get(dimensionKey);
        return world != null ? world.getConstraintManager() : null;
    }

    @Nullable
    public static VxTerrainSystem getTerrainSystem(class_5321<class_1937> dimensionKey) {
        VxPhysicsWorld world = VxPhysicsWorld.get(dimensionKey);
        return world != null ? world.getTerrainSystem() : null;
    }

    @Nullable
    public static VxMountingManager getMountingManager(class_5321<class_1937> dimensionKey) {
        VxPhysicsWorld world = VxPhysicsWorld.get(dimensionKey);
        return world != null ? world.getMountingManager() : null;
    }

    @Nullable
    public static VxBuoyancyManager getBuoyancyManager(class_5321<class_1937> dimensionKey) {
        VxPhysicsWorld world = VxPhysicsWorld.get(dimensionKey);
        return world != null ? world.getBuoyancyManager() : null;
    }

    public static Collection<VxPhysicsWorld> getAll() {
        return Collections.unmodifiableCollection(worlds.values());
    }
}

