/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.NonCopyable;
import com.github.stephengold.joltjni.PhysicsMaterial;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Shape;
import com.github.stephengold.joltjni.ShapeRefC;
import com.github.stephengold.joltjni.StateRecorder;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EGroundState;
import com.github.stephengold.joltjni.readonly.ConstCharacterBase;
import com.github.stephengold.joltjni.readonly.ConstPhysicsMaterial;
import com.github.stephengold.joltjni.readonly.ConstShape;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import com.github.stephengold.joltjni.template.RefTarget;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;

public abstract class CharacterBase
extends NonCopyable
implements ConstCharacterBase,
RefTarget {
    CharacterBase() {
    }

    public void restoreState(StateRecorder recorder) {
        long characterVa = this.va();
        long recorderVa = recorder.va();
        CharacterBase.restoreState(characterVa, recorderVa);
    }

    public void setMaxSlopeAngle(float angle) {
        long characterVa = this.va();
        CharacterBase.setMaxSlopeAngle(characterVa, angle);
    }

    public void setUp(Vec3Arg up) {
        long characterVa = this.va();
        float x = up.getX();
        float y = up.getY();
        float z = up.getZ();
        CharacterBase.setUp(characterVa, x, y, z);
    }

    @Override
    public float getCosMaxSlopeAngle() {
        long characterVa = this.va();
        float result = CharacterBase.getCosMaxSlopeAngle(characterVa);
        return result;
    }

    @Override
    public int getGroundBodyId() {
        long characterVa = this.va();
        int result = CharacterBase.getGroundBodyId(characterVa);
        return result;
    }

    @Override
    public ConstPhysicsMaterial getGroundMaterial() {
        long characterVa = this.va();
        long materialVa = CharacterBase.getGroundMaterial(characterVa);
        PhysicsMaterial result = materialVa == 0L ? null : new PhysicsMaterial(materialVa);
        return result;
    }

    @Override
    public Vec3 getGroundNormal() {
        long characterVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CharacterBase.getGroundNormal(characterVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public RVec3 getGroundPosition() {
        long characterVa = this.va();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        CharacterBase.getGroundPosition(characterVa, storeDoubles);
        RVec3 result = new RVec3(storeDoubles);
        return result;
    }

    @Override
    public EGroundState getGroundState() {
        long characterVa = this.va();
        int ordinal = CharacterBase.getGroundState(characterVa);
        EGroundState result = EGroundState.values()[ordinal];
        return result;
    }

    @Override
    public int getGroundSubShapeId() {
        long characterVa = this.va();
        int result = CharacterBase.getGroundSubShapeId(characterVa);
        return result;
    }

    @Override
    public long getGroundUserData() {
        long characterVa = this.va();
        long result = CharacterBase.getGroundUserData(characterVa);
        return result;
    }

    @Override
    public Vec3 getGroundVelocity() {
        long characterVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CharacterBase.getGroundVelocity(characterVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public ConstShape getShape() {
        long characterVa = this.va();
        long shapeVa = CharacterBase.getShape(characterVa);
        Shape result = Shape.newShape(shapeVa);
        return result;
    }

    @Override
    public void getShape(ShapeRefC storeRef) {
        long characterVa = this.va();
        long refVa = storeRef.va();
        CharacterBase.getShapeUpdate(characterVa, refVa);
    }

    @Override
    public Vec3 getUp() {
        long characterVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CharacterBase.getUp(characterVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public boolean isSlopeTooSteep(Vec3Arg normal) {
        long characterVa = this.va();
        float nx = normal.getX();
        float ny = normal.getY();
        float nz = normal.getZ();
        boolean result = CharacterBase.isSlopeTooSteep(characterVa, nx, ny, nz);
        return result;
    }

    @Override
    public boolean isSupported() {
        long characterVa = this.va();
        boolean result = CharacterBase.isSupported(characterVa);
        return result;
    }

    @Override
    public void saveState(StateRecorder recorder) {
        long characterVa = this.va();
        long recorderVa = recorder.va();
        CharacterBase.saveState(characterVa, recorderVa);
    }

    @Override
    public int getRefCount() {
        long characterVa = this.va();
        int result = CharacterBase.getRefCount(characterVa);
        return result;
    }

    @Override
    public void setEmbedded() {
        long characterVa = this.va();
        CharacterBase.setEmbedded(characterVa);
    }

    static native float getCosMaxSlopeAngle(long var0);

    static native int getGroundBodyId(long var0);

    static native long getGroundMaterial(long var0);

    static native void getGroundNormal(long var0, FloatBuffer var2);

    static native void getGroundPosition(long var0, DoubleBuffer var2);

    static native int getGroundState(long var0);

    static native int getGroundSubShapeId(long var0);

    static native long getGroundUserData(long var0);

    static native void getGroundVelocity(long var0, FloatBuffer var2);

    static native int getRefCount(long var0);

    static native long getShape(long var0);

    static native void getShapeUpdate(long var0, long var2);

    static native void getUp(long var0, FloatBuffer var2);

    static native boolean isSlopeTooSteep(long var0, float var2, float var3, float var4);

    static native boolean isSupported(long var0);

    static native void restoreState(long var0, long var2);

    static native void saveState(long var0, long var2);

    private static native void setEmbedded(long var0);

    private static native void setMaxSlopeAngle(long var0, float var2);

    static native void setUp(long var0, float var2, float var3, float var4);
}

