/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.Plane;
import com.github.stephengold.joltjni.Shape;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.ConstCharacterBaseSettings;
import com.github.stephengold.joltjni.readonly.ConstPlane;
import com.github.stephengold.joltjni.readonly.ConstShape;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public class CharacterBaseSettings
extends JoltPhysicsObject
implements ConstCharacterBaseSettings {
    CharacterBaseSettings() {
    }

    public void setEnhancedInternalEdgeRemoval(boolean remove) {
        long settingsVa = this.va();
        CharacterBaseSettings.setEnhancedInternalEdgeRemoval(settingsVa, remove);
    }

    public void setMaxSlopeAngle(float angle) {
        long settingsVa = this.va();
        CharacterBaseSettings.setMaxSlopeAngle(settingsVa, angle);
    }

    public void setShape(ConstShape shape) {
        long settingsVa = this.va();
        long shapeVa = shape.targetVa();
        CharacterBaseSettings.setShape(settingsVa, shapeVa);
    }

    public void setSupportingVolume(ConstPlane plane) {
        long settingsVa = this.va();
        float nx = plane.getNormalX();
        float ny = plane.getNormalY();
        float nz = plane.getNormalZ();
        float c = plane.getConstant();
        CharacterBaseSettings.setSupportingVolume(settingsVa, nx, ny, nz, c);
    }

    public void setUp(Vec3Arg direction) {
        long settingsVa = this.va();
        float dx = direction.getX();
        float dy = direction.getY();
        float dz = direction.getZ();
        CharacterBaseSettings.setUp(settingsVa, dx, dy, dz);
    }

    @Override
    public boolean getEnhancedInternalEdgeRemoval() {
        long settingsVa = this.va();
        boolean result = CharacterBaseSettings.getEnhancedInternalEdgeRemoval(settingsVa);
        return result;
    }

    @Override
    public float getMaxSlopeAngle() {
        long settingsVa = this.va();
        float result = CharacterBaseSettings.getMaxSlopeAngle(settingsVa);
        return result;
    }

    @Override
    public int getRefCount() {
        long settingsVa = this.va();
        int result = CharacterBaseSettings.getRefCount(settingsVa);
        return result;
    }

    @Override
    public ConstShape getShape() {
        long bodySettingsVa = this.va();
        long shapeSettingsVa = CharacterBaseSettings.getShape(bodySettingsVa);
        Shape result = Shape.newShape(shapeSettingsVa);
        return result;
    }

    @Override
    public Plane getSupportingVolume() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CharacterBaseSettings.getSupportingVolume(settingsVa, storeFloats);
        Plane result = new Plane(storeFloats);
        return result;
    }

    @Override
    public Vec3 getUp() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CharacterBaseSettings.getUp(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    static native boolean getEnhancedInternalEdgeRemoval(long var0);

    static native float getMaxSlopeAngle(long var0);

    static native int getRefCount(long var0);

    static native long getShape(long var0);

    static native void getSupportingVolume(long var0, FloatBuffer var2);

    static native void getUp(long var0, FloatBuffer var2);

    static native void setEnhancedInternalEdgeRemoval(long var0, boolean var2);

    static native void setMaxSlopeAngle(long var0, float var2);

    static native void setShape(long var0, long var2);

    static native void setSupportingVolume(long var0, float var2, float var3, float var4, float var5);

    static native void setUp(long var0, float var2, float var3, float var4);
}

