/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.readonly.ConstColor;

public final class Color
implements ConstColor {
    private static final ConstColor[] sColors = new ConstColor[]{new Color(255, 0, 0), new Color(204, 143, 102), new Color(226, 242, 0), new Color(41, 166, 124), new Color(0, 170, 255), new Color(69, 38, 153), new Color(153, 38, 130), new Color(229, 57, 80), new Color(204, 0, 0), new Color(255, 170, 0), new Color(85, 128, 0), new Color(64, 255, 217), new Color(0, 75, 140), new Color(161, 115, 230), new Color(242, 61, 157), new Color(178, 101, 89), new Color(140, 94, 0), new Color(181, 217, 108), new Color(64, 242, 255), new Color(77, 117, 153), new Color(157, 61, 242), new Color(140, 0, 56), new Color(127, 57, 32), new Color(204, 173, 51), new Color(64, 255, 64), new Color(38, 145, 153), new Color(0, 102, 255), new Color(242, 0, 226), new Color(153, 77, 107), new Color(229, 92, 0), new Color(140, 126, 70), new Color(0, 179, 71), new Color(0, 194, 242), new Color(27, 0, 204), new Color(230, 115, 222), new Color(127, 0, 17)};
    public static final ConstColor sBlack = new Color(0, 0, 0);
    public static final ConstColor sBlue = new Color(0, 0, 255);
    public static final ConstColor sCyan = new Color(0, 255, 255);
    public static final ConstColor sDarkBlue = new Color(0, 0, 128);
    public static final ConstColor sDarkGreen = new Color(0, 128, 0);
    public static final ConstColor sDarkOrange = new Color(128, 64, 0);
    public static final ConstColor sDarkRed = new Color(128, 0, 0);
    public static final ConstColor sGreen = new Color(0, 255, 0);
    public static final ConstColor sGrey = new Color(128, 128, 128);
    public static final ConstColor sLightGrey = new Color(192, 192, 192);
    public static final ConstColor sOrange = new Color(255, 128, 0);
    public static final ConstColor sPurple = new Color(255, 0, 255);
    public static final ConstColor sRed = new Color(255, 0, 0);
    public static final ConstColor sWhite = new Color(255, 255, 255);
    public static final ConstColor sYellow = new Color(255, 255, 0);
    private byte a;
    private byte b;
    private byte g;
    private byte r;

    public Color() {
    }

    public Color(ConstColor existing) {
        this.a = existing.getA();
        this.b = existing.getB();
        this.g = existing.getG();
        this.r = existing.getR();
    }

    public Color(int u32) {
        this.a = (byte)(u32 >> 24);
        this.b = (byte)(u32 >> 16);
        this.g = (byte)(u32 >> 8);
        this.r = (byte)u32;
    }

    public Color(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public Color(int r, int g, int b, int a) {
        this.a = (byte)a;
        this.b = (byte)b;
        this.g = (byte)g;
        this.r = (byte)r;
    }

    public void set(byte r, byte g, byte b, byte a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public void set(ConstColor source) {
        this.r = source.getR();
        this.g = source.getG();
        this.b = source.getB();
        this.a = source.getA();
    }

    public void setA(int a) {
        this.a = (byte)a;
    }

    public void setB(int b) {
        this.b = (byte)b;
    }

    public void setG(int g) {
        this.g = (byte)g;
    }

    public void setR(int r) {
        this.r = (byte)r;
    }

    public void setU32(int u32) {
        this.a = (byte)(u32 >> 24);
        this.b = (byte)(u32 >> 16);
        this.g = (byte)(u32 >> 8);
        this.r = (byte)u32;
    }

    public static Color sGetDistinctColor(int index) {
        int j = index % sColors.length;
        Color result = new Color(sColors[j]);
        return result;
    }

    @Override
    public byte getA() {
        return this.a;
    }

    @Override
    public byte getB() {
        return this.b;
    }

    @Override
    public byte getG() {
        return this.g;
    }

    @Override
    public byte getR() {
        return this.r;
    }

    @Override
    public int getUInt32() {
        int aa = this.a << 24;
        int bb = this.b << 16;
        int gg = this.g << 8;
        int result = aa & 0xFF000000 | bb & 0xFF0000 | gg & 0xFF00 | this.r & 0xFF;
        return result;
    }
}

