/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Constraint;
import com.github.stephengold.joltjni.ConstraintSettingsRef;
import com.github.stephengold.joltjni.StateRecorder;
import com.github.stephengold.joltjni.enumerate.EConstraintSubType;
import com.github.stephengold.joltjni.enumerate.EConstraintType;
import com.github.stephengold.joltjni.readonly.ConstConstraint;
import com.github.stephengold.joltjni.template.Ref;

public final class ConstraintRef
extends Ref
implements ConstConstraint {
    public ConstraintRef() {
        long refVa = ConstraintRef.createDefault();
        this.setVirtualAddress(refVa, () -> ConstraintRef.free(refVa));
    }

    ConstraintRef(long refVa, boolean owner) {
        Runnable freeingAction = owner ? () -> ConstraintRef.free(refVa) : null;
        this.setVirtualAddress(refVa, freeingAction);
    }

    @Override
    public int getConstraintPriority() {
        long constraintVa = this.targetVa();
        int result = Constraint.getConstraintPriority(constraintVa);
        return result;
    }

    @Override
    public ConstraintSettingsRef getConstraintSettings() {
        long constraintVa = this.targetVa();
        long settingsRefVa = Constraint.getConstraintSettings(constraintVa);
        ConstraintSettingsRef result = new ConstraintSettingsRef(settingsRefVa, true);
        return result;
    }

    @Override
    public boolean getEnabled() {
        long constraintVa = this.targetVa();
        boolean result = Constraint.getEnabled(constraintVa);
        return result;
    }

    @Override
    public int getNumPositionStepsOverride() {
        long constraintVa = this.targetVa();
        int result = Constraint.getNumPositionStepsOverride(constraintVa);
        return result;
    }

    @Override
    public int getNumVelocityStepsOverride() {
        long constraintVa = this.targetVa();
        int result = Constraint.getNumVelocityStepsOverride(constraintVa);
        return result;
    }

    @Override
    public EConstraintSubType getSubType() {
        long constraintVa = this.targetVa();
        int ordinal = Constraint.getSubType(constraintVa);
        EConstraintSubType result = EConstraintSubType.values()[ordinal];
        return result;
    }

    @Override
    public EConstraintType getType() {
        long constraintVa = this.targetVa();
        int ordinal = Constraint.getType(constraintVa);
        EConstraintType result = EConstraintType.values()[ordinal];
        return result;
    }

    @Override
    public boolean isActive() {
        long constraintVa = this.targetVa();
        boolean result = Constraint.isActive(constraintVa);
        return result;
    }

    @Override
    public void saveState(StateRecorder recorder) {
        long constraintVa = this.targetVa();
        long recorderVa = recorder.va();
        Constraint.saveState(constraintVa, recorderVa);
    }

    @Override
    public Constraint getPtr() {
        long constraintVa = this.targetVa();
        Constraint result = Constraint.newConstraint(constraintVa);
        return result;
    }

    @Override
    public long targetVa() {
        long refVa = this.va();
        long result = ConstraintRef.getPtr(refVa);
        return result;
    }

    @Override
    public ConstraintRef toRef() {
        long refVa = this.va();
        long copyVa = ConstraintRef.copy(refVa);
        ConstraintRef result = new ConstraintRef(copyVa, true);
        return result;
    }

    private static native long copy(long var0);

    private static native long createDefault();

    static native void free(long var0);

    private static native long getPtr(long var0);
}

