/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.TwoBodyConstraintSettings;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EConstraintSpace;
import com.github.stephengold.joltjni.enumerate.EConstraintSubType;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;

public class FixedConstraintSettings
extends TwoBodyConstraintSettings {
    public FixedConstraintSettings() {
        long settingsVa = FixedConstraintSettings.createDefault();
        this.setVirtualAddressAsCoOwner(settingsVa, EConstraintSubType.Fixed);
    }

    public FixedConstraintSettings(FixedConstraintSettings original) {
        long originalVa = original.va();
        long copyVa = FixedConstraintSettings.createCopy(originalVa);
        this.setVirtualAddressAsCoOwner(copyVa, EConstraintSubType.Fixed);
    }

    FixedConstraintSettings(long settingsVa) {
        this.setVirtualAddressAsCoOwner(settingsVa, EConstraintSubType.Fixed);
    }

    public boolean getAutoDetectPoint() {
        long settingsVa = this.va();
        boolean result = FixedConstraintSettings.getAutoDetectPoint(settingsVa);
        return result;
    }

    public Vec3 getAxisX1() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        FixedConstraintSettings.getAxisX1(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public Vec3 getAxisX2() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        FixedConstraintSettings.getAxisX2(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public Vec3 getAxisY1() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        FixedConstraintSettings.getAxisY1(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public Vec3 getAxisY2() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        FixedConstraintSettings.getAxisY2(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public RVec3 getPoint1() {
        long settingsVa = this.va();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        FixedConstraintSettings.getPoint1(settingsVa, storeDoubles);
        RVec3 result = new RVec3(storeDoubles);
        return result;
    }

    public RVec3 getPoint2() {
        long settingsVa = this.va();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        FixedConstraintSettings.getPoint2(settingsVa, storeDoubles);
        RVec3 result = new RVec3(storeDoubles);
        return result;
    }

    public EConstraintSpace getSpace() {
        long settingsVa = this.va();
        int ordinal = FixedConstraintSettings.getSpace(settingsVa);
        EConstraintSpace result = EConstraintSpace.values()[ordinal];
        return result;
    }

    public void setAutoDetectPoint(boolean setting) {
        long settingsVa = this.va();
        FixedConstraintSettings.setAutoDetectPoint(settingsVa, setting);
    }

    public void setAxisX1(Vec3Arg axis) {
        long settingsVa = this.va();
        float x = axis.getX();
        float y = axis.getY();
        float z = axis.getZ();
        FixedConstraintSettings.setAxisX1(settingsVa, x, y, z);
    }

    public void setAxisX2(Vec3Arg axis) {
        long settingsVa = this.va();
        float x = axis.getX();
        float y = axis.getY();
        float z = axis.getZ();
        FixedConstraintSettings.setAxisX2(settingsVa, x, y, z);
    }

    public void setAxisY1(Vec3Arg axis) {
        long settingsVa = this.va();
        float x = axis.getX();
        float y = axis.getY();
        float z = axis.getZ();
        FixedConstraintSettings.setAxisY1(settingsVa, x, y, z);
    }

    public void setAxisY2(Vec3Arg axis) {
        long settingsVa = this.va();
        float x = axis.getX();
        float y = axis.getY();
        float z = axis.getZ();
        FixedConstraintSettings.setAxisY2(settingsVa, x, y, z);
    }

    public RVec3Arg setPoint1(RVec3Arg location) {
        long settingsVa = this.va();
        double x = location.xx();
        double y = location.yy();
        double z = location.zz();
        FixedConstraintSettings.setPoint1(settingsVa, x, y, z);
        return location;
    }

    public RVec3Arg setPoint2(RVec3Arg location) {
        long settingsVa = this.va();
        double x = location.xx();
        double y = location.yy();
        double z = location.zz();
        FixedConstraintSettings.setPoint2(settingsVa, x, y, z);
        return location;
    }

    public void setSpace(EConstraintSpace space) {
        long settingsVa = this.va();
        int ordinal = space.ordinal();
        FixedConstraintSettings.setSpace(settingsVa, ordinal);
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native boolean getAutoDetectPoint(long var0);

    private static native void getAxisX1(long var0, FloatBuffer var2);

    private static native void getAxisX2(long var0, FloatBuffer var2);

    private static native void getAxisY1(long var0, FloatBuffer var2);

    private static native void getAxisY2(long var0, FloatBuffer var2);

    private static native void getPoint1(long var0, DoubleBuffer var2);

    private static native void getPoint2(long var0, DoubleBuffer var2);

    private static native int getSpace(long var0);

    private static native void setAutoDetectPoint(long var0, boolean var2);

    private static native void setAxisX1(long var0, float var2, float var3, float var4);

    private static native void setAxisX2(long var0, float var2, float var3, float var4);

    private static native void setAxisY1(long var0, float var2, float var3, float var4);

    private static native void setAxisY2(long var0, float var2, float var3, float var4);

    private static native void setPoint1(long var0, double var2, double var4, double var6);

    private static native void setPoint2(long var0, double var2, double var4, double var6);

    private static native void setSpace(long var0, int var2);
}

