/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.readonly.ConstIndexedTriangleNoMaterial;

public class IndexedTriangleNoMaterial
extends JoltPhysicsObject
implements ConstIndexedTriangleNoMaterial {
    public IndexedTriangleNoMaterial() {
        this(0, 0, 0);
    }

    IndexedTriangleNoMaterial(boolean dummy) {
    }

    public IndexedTriangleNoMaterial(int vi0, int vi1, int vi2) {
        long triangleVa = IndexedTriangleNoMaterial.createIndexedTriangleNoMaterial(vi0, vi1, vi2);
        this.setVirtualAddress(triangleVa, () -> IndexedTriangleNoMaterial.free(triangleVa));
    }

    IndexedTriangleNoMaterial(JoltPhysicsObject container, long triangleVa) {
        super(container, triangleVa);
    }

    public void setIdx(int cornerIndex, int meshVertexIndex) {
        long triangleVa = this.va();
        IndexedTriangleNoMaterial.setIdx(triangleVa, cornerIndex, meshVertexIndex);
    }

    @Override
    public int getIdx(int cornerIndex) {
        long triangleVa = this.va();
        int result = IndexedTriangleNoMaterial.getIdx(triangleVa, cornerIndex);
        return result;
    }

    final void setVirtualAddressAsOwner(long triangleVa) {
        Runnable freeingAction = () -> IndexedTriangleNoMaterial.free(triangleVa);
        this.setVirtualAddress(triangleVa, freeingAction);
    }

    private static native long createIndexedTriangleNoMaterial(int var0, int var1, int var2);

    private static native void free(long var0);

    private static native int getIdx(long var0, int var2);

    private static native void setIdx(long var0, int var2, int var3);
}

