/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Constraint;
import com.github.stephengold.joltjni.ConstraintRef;
import com.github.stephengold.joltjni.ConstraintSettings;
import com.github.stephengold.joltjni.ConstraintSettingsRef;
import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.SpringSettings;
import com.github.stephengold.joltjni.readonly.ConstMotorSettings;

public final class MotorSettings
extends JoltPhysicsObject
implements ConstMotorSettings {
    public MotorSettings() {
        long settingsVa = MotorSettings.createDefault();
        this.setVirtualAddress(settingsVa, () -> MotorSettings.free(settingsVa));
    }

    public MotorSettings(float frequency, float damping) {
        long settingsVa = MotorSettings.createUnlimited(frequency, damping);
        this.setVirtualAddress(settingsVa, () -> MotorSettings.free(settingsVa));
    }

    public MotorSettings(float frequency, float damping, float forceLimit, float torqueLimit) {
        long settingsVa = MotorSettings.createLimited(frequency, damping, forceLimit, torqueLimit);
        this.setVirtualAddress(settingsVa, () -> MotorSettings.free(settingsVa));
    }

    MotorSettings(JoltPhysicsObject container, long settingsVa) {
        super(container, settingsVa);
    }

    public MotorSettings(ConstMotorSettings original) {
        long originalVa = original.targetVa();
        long copyVa = MotorSettings.createCopy(originalVa);
        this.setVirtualAddress(copyVa, () -> MotorSettings.free(copyVa));
    }

    public void setForceLimit(float limit) {
        long settingsVa = this.va();
        MotorSettings.setForceLimit(settingsVa, limit);
    }

    public void setForceLimits(float min, float max) {
        long settingsVa = this.va();
        MotorSettings.setForceLimits(settingsVa, min, max);
    }

    public void setMaxForceLimit(float force) {
        long settingsVa = this.va();
        MotorSettings.setMaxForceLimit(settingsVa, force);
    }

    public void setMaxTorqueLimit(float torque) {
        long settingsVa = this.va();
        MotorSettings.setMaxTorqueLimit(settingsVa, torque);
    }

    public void setMinForceLimit(float force) {
        long settingsVa = this.va();
        MotorSettings.setMinForceLimit(settingsVa, force);
    }

    public void setMinTorqueLimit(float torque) {
        long settingsVa = this.va();
        MotorSettings.setMinTorqueLimit(settingsVa, torque);
    }

    public void setTorqueLimit(float limit) {
        long settingsVa = this.va();
        MotorSettings.setTorqueLimit(settingsVa, limit);
    }

    public void setTorqueLimits(float min, float max) {
        long settingsVa = this.va();
        MotorSettings.setTorqueLimits(settingsVa, min, max);
    }

    @Override
    public Constraint getConstraint() {
        JoltPhysicsObject container = this.getContainingObject();
        Constraint result = container instanceof ConstraintRef ? ((ConstraintRef)container).getPtr() : null;
        return result;
    }

    @Override
    public ConstraintSettings getConstraintSettings() {
        JoltPhysicsObject container = this.getContainingObject();
        ConstraintSettings result = container instanceof ConstraintSettingsRef ? ((ConstraintSettingsRef)container).getPtr() : null;
        return result;
    }

    @Override
    public float getMaxForceLimit() {
        long settingsVa = this.va();
        float result = MotorSettings.getMaxForceLimit(settingsVa);
        return result;
    }

    @Override
    public float getMaxTorqueLimit() {
        long settingsVa = this.va();
        float result = MotorSettings.getMaxTorqueLimit(settingsVa);
        return result;
    }

    @Override
    public float getMinForceLimit() {
        long settingsVa = this.va();
        float result = MotorSettings.getMinForceLimit(settingsVa);
        return result;
    }

    @Override
    public float getMinTorqueLimit() {
        long settingsVa = this.va();
        float result = MotorSettings.getMinTorqueLimit(settingsVa);
        return result;
    }

    @Override
    public SpringSettings getSpringSettings() {
        long motorSettingsVa = this.va();
        long springSettingsVa = MotorSettings.getSpringSettings(motorSettingsVa);
        ConstraintSettings constraintSettings = this.getConstraintSettings();
        SpringSettings result = new SpringSettings(constraintSettings, springSettingsVa);
        return result;
    }

    @Override
    public boolean isValid() {
        long settingsVa = this.va();
        boolean result = MotorSettings.isValid(settingsVa);
        return result;
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native long createLimited(float var0, float var1, float var2, float var3);

    private static native long createUnlimited(float var0, float var1);

    private static native void free(long var0);

    private static native float getMaxForceLimit(long var0);

    private static native float getMaxTorqueLimit(long var0);

    private static native float getMinForceLimit(long var0);

    private static native float getMinTorqueLimit(long var0);

    private static native long getSpringSettings(long var0);

    private static native boolean isValid(long var0);

    private static native void setForceLimit(long var0, float var2);

    private static native void setForceLimits(long var0, float var2, float var3);

    private static native void setMaxForceLimit(long var0, float var2);

    private static native void setMaxTorqueLimit(long var0, float var2);

    private static native void setMinForceLimit(long var0, float var2);

    private static native void setMinTorqueLimit(long var0, float var2);

    private static native void setTorqueLimit(long var0, float var2);

    private static native void setTorqueLimits(long var0, float var2, float var3);
}

