/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.CompoundShape;
import com.github.stephengold.joltjni.readonly.ConstShape;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.ByteBuffer;

public class MutableCompoundShape
extends CompoundShape {
    public MutableCompoundShape() {
        long shapeVa = MutableCompoundShape.createMutableCompoundShape();
        this.setVirtualAddressAsCoOwner(shapeVa);
    }

    MutableCompoundShape(long shapeVa) {
        this.setVirtualAddressAsCoOwner(shapeVa);
    }

    public int addShape(Vec3Arg offset, QuatArg rotation, ConstShape subshape) {
        long compoundVa = this.va();
        float offsetX = offset.getX();
        float offsetY = offset.getY();
        float offsetZ = offset.getZ();
        float rotW = rotation.getW();
        float rotX = rotation.getX();
        float rotY = rotation.getY();
        float rotZ = rotation.getZ();
        long subShapeVa = subshape.targetVa();
        int result = MutableCompoundShape.addShape(compoundVa, offsetX, offsetY, offsetZ, rotX, rotY, rotZ, rotW, subShapeVa);
        return result;
    }

    public void adjustCenterOfMass() {
        long shapeVa = this.va();
        MutableCompoundShape.adjustCenterOfMass(shapeVa);
    }

    public void modifyShapes(int startIndex, int numSubshapes, ByteBuffer offsets, ByteBuffer rotations, int offsetStride, int rotationStride) {
        long shapeVa = this.va();
        MutableCompoundShape.modifyShapes(shapeVa, startIndex, numSubshapes, offsets, rotations, offsetStride, rotationStride);
    }

    public void removeShape(int index) {
        long shapeVa = this.va();
        MutableCompoundShape.removeShape(shapeVa, index);
    }

    private static native int addShape(long var0, float var2, float var3, float var4, float var5, float var6, float var7, float var8, long var9);

    private static native void adjustCenterOfMass(long var0);

    private static native long createMutableCompoundShape();

    private static native void modifyShapes(long var0, int var2, int var3, ByteBuffer var4, ByteBuffer var5, int var6, int var7);

    private static native void removeShape(long var0, int var2);
}

