/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.DecoratedShapeSettings;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EShapeSubType;
import com.github.stephengold.joltjni.readonly.ConstShape;
import com.github.stephengold.joltjni.readonly.ConstShapeSettings;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public class OffsetCenterOfMassShapeSettings
extends DecoratedShapeSettings {
    OffsetCenterOfMassShapeSettings(long ocomssVa) {
        this.setVirtualAddressAsCoOwner(ocomssVa, EShapeSubType.OffsetCenterOfMass);
    }

    public OffsetCenterOfMassShapeSettings(OffsetCenterOfMassShapeSettings original) {
        long originalVa = original.va();
        long copyVa = OffsetCenterOfMassShapeSettings.createCopy(originalVa);
        this.setVirtualAddressAsCoOwner(copyVa, EShapeSubType.OffsetCenterOfMass);
    }

    public OffsetCenterOfMassShapeSettings(Vec3Arg offset, ConstShape baseShape) {
        float offsetX = offset.getX();
        float offsetY = offset.getY();
        float offsetZ = offset.getZ();
        long baseShapeVa = baseShape.targetVa();
        long ocomssVa = OffsetCenterOfMassShapeSettings.createSettingsFromShape(offsetX, offsetY, offsetZ, baseShapeVa);
        this.setVirtualAddressAsCoOwner(ocomssVa, EShapeSubType.OffsetCenterOfMass);
    }

    public OffsetCenterOfMassShapeSettings(Vec3Arg offset, ConstShapeSettings baseShapeSettings) {
        float offsetX = offset.getX();
        float offsetY = offset.getY();
        float offsetZ = offset.getZ();
        long baseShapeSettingsVa = baseShapeSettings.targetVa();
        long ocomssVa = OffsetCenterOfMassShapeSettings.createSettingsFromSettings(offsetX, offsetY, offsetZ, baseShapeSettingsVa);
        this.setVirtualAddressAsCoOwner(ocomssVa, EShapeSubType.OffsetCenterOfMass);
    }

    public Vec3 getOffset() {
        long ocomssVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        OffsetCenterOfMassShapeSettings.getOffset(ocomssVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public void setOffset(Vec3Arg offset) {
        long ocomssVa = this.va();
        float offsetX = offset.getX();
        float offsetY = offset.getY();
        float offsetZ = offset.getZ();
        OffsetCenterOfMassShapeSettings.setOffset(ocomssVa, offsetX, offsetY, offsetZ);
    }

    private static native long createCopy(long var0);

    private static native long createSettingsFromSettings(float var0, float var1, float var2, long var3);

    private static native long createSettingsFromShape(float var0, float var1, float var2, long var3);

    private static native void getOffset(long var0, FloatBuffer var2);

    private static native void setOffset(long var0, float var2, float var3, float var4);
}

