/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.Mat44;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.ConstOrientedBox;
import com.github.stephengold.joltjni.readonly.Mat44Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public final class OrientedBox
extends JoltPhysicsObject
implements ConstOrientedBox {
    public OrientedBox() {
        long boxVa = OrientedBox.createDefault();
        this.setVirtualAddress(boxVa, () -> OrientedBox.free(boxVa));
    }

    public OrientedBox(ConstOrientedBox original) {
        long originalVa = original.targetVa();
        long copyVa = OrientedBox.createCopy(originalVa);
        this.setVirtualAddress(copyVa, () -> OrientedBox.free(copyVa));
    }

    public OrientedBox(Mat44Arg orientation, Vec3Arg halfExtents) {
        long orientationVa = orientation.targetVa();
        float hx = halfExtents.getX();
        float hy = halfExtents.getY();
        float hz = halfExtents.getZ();
        long boxVa = OrientedBox.createBox(orientationVa, hx, hy, hz);
        this.setVirtualAddress(boxVa, () -> OrientedBox.free(boxVa));
    }

    @Override
    public Vec3 getHalfExtents() {
        long boxVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        OrientedBox.getHalfExtents(boxVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public Mat44 getOrientation() {
        long boxVa = this.va();
        long resultVa = OrientedBox.getOrientation(boxVa);
        Mat44 result = new Mat44(resultVa);
        return result;
    }

    private static native long createBox(long var0, float var2, float var3, float var4);

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native void free(long var0);

    private static native void getHalfExtents(long var0, FloatBuffer var2);

    private static native long getOrientation(long var0);
}

