/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.readonly.ConstPhysicsSettings;

public class PhysicsSettings
extends JoltPhysicsObject
implements ConstPhysicsSettings {
    public PhysicsSettings() {
        long settingsVa = PhysicsSettings.createDefault();
        this.setVirtualAddress(settingsVa, () -> PhysicsSettings.free(settingsVa));
    }

    PhysicsSettings(long settingsVa, boolean owner) {
        Runnable freeingAction = owner ? () -> PhysicsSettings.free(settingsVa) : null;
        this.setVirtualAddress(settingsVa, freeingAction);
    }

    public PhysicsSettings(ConstPhysicsSettings original) {
        long originalVa = original.targetVa();
        long copyVa = PhysicsSettings.createCopy(originalVa);
        this.setVirtualAddress(copyVa, () -> PhysicsSettings.free(copyVa));
    }

    public void setAllowSleeping(boolean allow) {
        long settingsVa = this.va();
        PhysicsSettings.setAllowSleeping(settingsVa, allow);
    }

    public void setBaumgarte(float fraction) {
        assert (fraction >= 0.0f && fraction <= 1.0f) : fraction;
        long settingsVa = this.va();
        PhysicsSettings.setBaumgarte(settingsVa, fraction);
    }

    public void setBodyPairCacheCosMaxDeltaRotationDiv2(float cosineOfHalfAngle) {
        assert (cosineOfHalfAngle >= 0.0f && cosineOfHalfAngle <= 1.0f) : cosineOfHalfAngle;
        long settingsVa = this.va();
        PhysicsSettings.setBodyPairCacheCosMaxDeltaRotationDiv2(settingsVa, cosineOfHalfAngle);
    }

    public void setBodyPairCacheMaxDeltaPositionSq(float squaredDistance) {
        assert (squaredDistance >= 0.0f) : squaredDistance;
        long settingsVa = this.va();
        PhysicsSettings.setBodyPairCacheMaxDeltaPositionSq(settingsVa, squaredDistance);
    }

    public void setCheckActiveEdges(boolean check) {
        long settingsVa = this.va();
        PhysicsSettings.setCheckActiveEdges(settingsVa, check);
    }

    public void setConstraintWarmStart(boolean enable) {
        long settingsVa = this.va();
        PhysicsSettings.setConstraintWarmStart(settingsVa, enable);
    }

    public void setContactNormalCosMaxDeltaRotation(float cosine) {
        assert (cosine >= -1.0f && cosine <= 1.0f) : cosine;
        long settingsVa = this.va();
        PhysicsSettings.setContactNormalCosMaxDeltaRotation(settingsVa, cosine);
    }

    public void setContactPointPreserveLambdaMaxDistSq(float squaredDistance) {
        assert (squaredDistance >= 0.0f) : squaredDistance;
        long settingsVa = this.va();
        PhysicsSettings.setContactPointPreserveLambdaMaxDistSq(settingsVa, squaredDistance);
    }

    public void setDeterministicSimulation(boolean setting) {
        long settingsVa = this.va();
        PhysicsSettings.setDeterministicSimulation(settingsVa, setting);
    }

    public void setLinearCastMaxPenetration(float distance) {
        assert (distance >= 0.0f) : distance;
        long settingsVa = this.va();
        PhysicsSettings.setLinearCastMaxPenetration(settingsVa, distance);
    }

    public void setLinearCastThreshold(float threshold) {
        assert (threshold >= 0.0f) : threshold;
        long settingsVa = this.va();
        PhysicsSettings.setLinearCastThreshold(settingsVa, threshold);
    }

    public void setManifoldTolerance(float tolerance) {
        assert (tolerance >= 0.0f) : tolerance;
        long settingsVa = this.va();
        PhysicsSettings.setManifoldTolerance(settingsVa, tolerance);
    }

    public void setMaxInFlightBodyPairs(int maxPairs) {
        assert (maxPairs >= 0) : maxPairs;
        long settingsVa = this.va();
        PhysicsSettings.setMaxInFlightBodyPairs(settingsVa, maxPairs);
    }

    public void setMaxPenetrationDistance(float distance) {
        assert (distance >= 0.0f) : distance;
        long settingsVa = this.va();
        PhysicsSettings.setMaxPenetrationDistance(settingsVa, distance);
    }

    public void setMinVelocityForRestitution(float speed) {
        assert (speed >= 0.0f) : speed;
        long settingsVa = this.va();
        PhysicsSettings.setMinVelocityForRestitution(settingsVa, speed);
    }

    public void setNumPositionSteps(int numSteps) {
        long settingsVa = this.va();
        PhysicsSettings.setNumPositionSteps(settingsVa, numSteps);
    }

    public void setNumVelocitySteps(int numSteps) {
        long settingsVa = this.va();
        PhysicsSettings.setNumVelocitySteps(settingsVa, numSteps);
    }

    public void setPenetrationSlop(float slop) {
        long settingsVa = this.va();
        PhysicsSettings.setPenetrationSlop(settingsVa, slop);
    }

    public void setPointVelocitySleepThreshold(float speed) {
        assert (speed >= 0.0f) : speed;
        long settingsVa = this.va();
        PhysicsSettings.setPointVelocitySleepThreshold(settingsVa, speed);
    }

    public void setSpeculativeContactDistance(float distance) {
        assert (distance >= 0.0f) : distance;
        long settingsVa = this.va();
        PhysicsSettings.setSpeculativeContactDistance(settingsVa, distance);
    }

    public void setStepListenerBatchesPerJob(int numBatches) {
        assert (numBatches > 0) : numBatches;
        long settingsVa = this.va();
        PhysicsSettings.setStepListenerBatchesPerJob(settingsVa, numBatches);
    }

    public void setStepListenersBatchSize(int numListeners) {
        assert (numListeners > 0) : numListeners;
        long settingsVa = this.va();
        PhysicsSettings.setStepListenersBatchSize(settingsVa, numListeners);
    }

    public void setTimeBeforeSleep(float interval) {
        assert (interval >= 0.0f) : interval;
        long settingsVa = this.va();
        PhysicsSettings.setTimeBeforeSleep(settingsVa, interval);
    }

    public void setUseBodyPairContactCache(boolean enable) {
        long settingsVa = this.va();
        PhysicsSettings.setUseBodyPairContactCache(settingsVa, enable);
    }

    public void setUseLargeIslandSplitter(boolean setting) {
        long settingsVa = this.va();
        PhysicsSettings.setUseLargeIslandSplitter(settingsVa, setting);
    }

    public void setUseManifoldReduction(boolean setting) {
        long settingsVa = this.va();
        PhysicsSettings.setUseManifoldReduction(settingsVa, setting);
    }

    @Override
    public boolean getAllowSleeping() {
        long settingsVa = this.va();
        boolean result = PhysicsSettings.getAllowSleeping(settingsVa);
        return result;
    }

    @Override
    public float getBaumgarte() {
        long settingsVa = this.va();
        float result = PhysicsSettings.getBaumgarte(settingsVa);
        assert (result >= 0.0f && result <= 1.0f) : result;
        return result;
    }

    @Override
    public float getBodyPairCacheCosMaxDeltaRotationDiv2() {
        long settingsVa = this.va();
        float result = PhysicsSettings.getBodyPairCacheCosMaxDeltaRotationDiv2(settingsVa);
        assert (result >= 0.0f && result <= 1.0f) : result;
        return result;
    }

    @Override
    public float getBodyPairCacheMaxDeltaPositionSq() {
        long settingsVa = this.va();
        float result = PhysicsSettings.getBodyPairCacheMaxDeltaPositionSq(settingsVa);
        assert (result >= 0.0f) : result;
        return result;
    }

    @Override
    public boolean getCheckActiveEdges() {
        long settingsVa = this.va();
        boolean result = PhysicsSettings.getCheckActiveEdges(settingsVa);
        return result;
    }

    @Override
    public boolean getConstraintWarmStart() {
        long settingsVa = this.va();
        boolean result = PhysicsSettings.getConstraintWarmStart(settingsVa);
        return result;
    }

    @Override
    public float getContactNormalCosMaxDeltaRotation() {
        long settingsVa = this.va();
        float result = PhysicsSettings.getContactNormalCosMaxDeltaRotation(settingsVa);
        assert (result >= -1.0f && result <= 1.0f) : result;
        return result;
    }

    @Override
    public float getContactPointPreserveLambdaMaxDistSq() {
        long settingsVa = this.va();
        float result = PhysicsSettings.getContactPointPreserveLambdaMaxDistSq(settingsVa);
        assert (result >= 0.0f) : result;
        return result;
    }

    @Override
    public boolean getDeterministicSimulation() {
        long settingsVa = this.va();
        boolean result = PhysicsSettings.getDeterministicSimulation(settingsVa);
        return result;
    }

    @Override
    public float getLinearCastMaxPenetration() {
        long settingsVa = this.va();
        float result = PhysicsSettings.getLinearCastMaxPenetration(settingsVa);
        assert (result >= 0.0f) : result;
        return result;
    }

    @Override
    public float getLinearCastThreshold() {
        long settingsVa = this.va();
        float result = PhysicsSettings.getLinearCastThreshold(settingsVa);
        assert (result >= 0.0f) : result;
        return result;
    }

    @Override
    public float getManifoldTolerance() {
        long settingsVa = this.va();
        float result = PhysicsSettings.getManifoldTolerance(settingsVa);
        assert (result >= 0.0f) : result;
        return result;
    }

    @Override
    public int getMaxInFlightBodyPairs() {
        long settingsVa = this.va();
        int result = PhysicsSettings.getMaxInFlightBodyPairs(settingsVa);
        assert (result >= 0) : result;
        return result;
    }

    @Override
    public float getMaxPenetrationDistance() {
        long settingsVa = this.va();
        float result = PhysicsSettings.getMaxPenetrationDistance(settingsVa);
        assert (result >= 0.0f) : result;
        return result;
    }

    @Override
    public float getMinVelocityForRestitution() {
        long settingsVa = this.va();
        float result = PhysicsSettings.getMinVelocityForRestitution(settingsVa);
        assert (result >= 0.0f) : result;
        return result;
    }

    @Override
    public int getNumPositionSteps() {
        long settingsVa = this.va();
        int result = PhysicsSettings.getNumPositionSteps(settingsVa);
        assert (result >= 0) : result;
        return result;
    }

    @Override
    public int getNumVelocitySteps() {
        long settingsVa = this.va();
        int result = PhysicsSettings.getNumVelocitySteps(settingsVa);
        assert (result >= 0) : result;
        return result;
    }

    @Override
    public float getPenetrationSlop() {
        long settingsVa = this.va();
        float result = PhysicsSettings.getPenetrationSlop(settingsVa);
        return result;
    }

    @Override
    public float getPointVelocitySleepThreshold() {
        long settingsVa = this.va();
        float result = PhysicsSettings.getPointVelocitySleepThreshold(settingsVa);
        assert (result >= 0.0f) : result;
        return result;
    }

    @Override
    public float getSpeculativeContactDistance() {
        long settingsVa = this.va();
        float result = PhysicsSettings.getSpeculativeContactDistance(settingsVa);
        assert (result >= 0.0f) : result;
        return result;
    }

    @Override
    public int getStepListenerBatchesPerJob() {
        long settingsVa = this.va();
        int result = PhysicsSettings.getStepListenerBatchesPerJob(settingsVa);
        assert (result > 0) : result;
        return result;
    }

    @Override
    public int getStepListenersBatchSize() {
        long settingsVa = this.va();
        int result = PhysicsSettings.getStepListenersBatchSize(settingsVa);
        assert (result > 0) : result;
        return result;
    }

    @Override
    public float getTimeBeforeSleep() {
        long settingsVa = this.va();
        float result = PhysicsSettings.getTimeBeforeSleep(settingsVa);
        assert (result >= 0.0f) : result;
        return result;
    }

    @Override
    public boolean getUseBodyPairContactCache() {
        long settingsVa = this.va();
        boolean result = PhysicsSettings.getUseBodyPairContactCache(settingsVa);
        return result;
    }

    @Override
    public boolean getUseLargeIslandSplitter() {
        long settingsVa = this.va();
        boolean result = PhysicsSettings.getUseLargeIslandSplitter(settingsVa);
        return result;
    }

    @Override
    public boolean getUseManifoldReduction() {
        long settingsVa = this.va();
        boolean result = PhysicsSettings.getUseManifoldReduction(settingsVa);
        return result;
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native void free(long var0);

    private static native boolean getAllowSleeping(long var0);

    private static native float getBaumgarte(long var0);

    private static native float getBodyPairCacheCosMaxDeltaRotationDiv2(long var0);

    private static native float getBodyPairCacheMaxDeltaPositionSq(long var0);

    private static native boolean getCheckActiveEdges(long var0);

    private static native boolean getConstraintWarmStart(long var0);

    private static native float getContactNormalCosMaxDeltaRotation(long var0);

    private static native float getContactPointPreserveLambdaMaxDistSq(long var0);

    private static native boolean getDeterministicSimulation(long var0);

    private static native float getLinearCastMaxPenetration(long var0);

    private static native float getLinearCastThreshold(long var0);

    private static native float getManifoldTolerance(long var0);

    private static native int getMaxInFlightBodyPairs(long var0);

    private static native float getMaxPenetrationDistance(long var0);

    private static native float getMinVelocityForRestitution(long var0);

    private static native int getNumPositionSteps(long var0);

    private static native int getNumVelocitySteps(long var0);

    private static native float getPenetrationSlop(long var0);

    private static native float getPointVelocitySleepThreshold(long var0);

    private static native float getSpeculativeContactDistance(long var0);

    private static native int getStepListenerBatchesPerJob(long var0);

    private static native int getStepListenersBatchSize(long var0);

    private static native float getTimeBeforeSleep(long var0);

    private static native boolean getUseBodyPairContactCache(long var0);

    private static native boolean getUseLargeIslandSplitter(long var0);

    private static native boolean getUseManifoldReduction(long var0);

    private static native void setAllowSleeping(long var0, boolean var2);

    private static native void setBaumgarte(long var0, float var2);

    private static native void setBodyPairCacheCosMaxDeltaRotationDiv2(long var0, float var2);

    private static native void setBodyPairCacheMaxDeltaPositionSq(long var0, float var2);

    private static native void setCheckActiveEdges(long var0, boolean var2);

    private static native void setConstraintWarmStart(long var0, boolean var2);

    private static native void setContactNormalCosMaxDeltaRotation(long var0, float var2);

    private static native void setContactPointPreserveLambdaMaxDistSq(long var0, float var2);

    private static native void setDeterministicSimulation(long var0, boolean var2);

    private static native void setLinearCastMaxPenetration(long var0, float var2);

    private static native void setLinearCastThreshold(long var0, float var2);

    private static native void setManifoldTolerance(long var0, float var2);

    private static native void setMaxInFlightBodyPairs(long var0, int var2);

    private static native void setMaxPenetrationDistance(long var0, float var2);

    private static native void setMinVelocityForRestitution(long var0, float var2);

    private static native void setNumPositionSteps(long var0, int var2);

    private static native void setNumVelocitySteps(long var0, int var2);

    private static native void setPenetrationSlop(long var0, float var2);

    private static native void setPointVelocitySleepThreshold(long var0, float var2);

    private static native void setSpeculativeContactDistance(long var0, float var2);

    private static native void setStepListenerBatchesPerJob(long var0, int var2);

    private static native void setStepListenersBatchSize(long var0, int var2);

    private static native void setTimeBeforeSleep(long var0, float var2);

    private static native void setUseBodyPairContactCache(long var0, boolean var2);

    private static native void setUseLargeIslandSplitter(long var0, boolean var2);

    private static native void setUseManifoldReduction(long var0, boolean var2);
}

