/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.readonly.ConstRodBendTwist;
import com.github.stephengold.joltjni.readonly.QuatArg;
import java.nio.FloatBuffer;

public class RodBendTwist
extends JoltPhysicsObject
implements ConstRodBendTwist {
    public RodBendTwist() {
        long constraintVa = RodBendTwist.createDefault();
        this.setVirtualAddress(constraintVa, () -> RodBendTwist.free(constraintVa));
    }

    public RodBendTwist(int rod0, int rod1) {
        this(rod0, rod1, 0.0f);
    }

    public RodBendTwist(int rod0, int rod1, float compliance) {
        long rodVa = RodBendTwist.create(rod0, rod1, compliance);
        this.setVirtualAddress(rodVa, () -> RodBendTwist.free(rodVa));
    }

    RodBendTwist(JoltPhysicsObject container, long constraintVa) {
        super(container, constraintVa);
    }

    public RodBendTwist setCompliance(float compliance) {
        long constraintVa = this.va();
        RodBendTwist.setCompliance(constraintVa, compliance);
        return this;
    }

    public RodBendTwist setOmega0(QuatArg omega0) {
        long constraintVa = this.va();
        float qx = omega0.getX();
        float qy = omega0.getY();
        float qz = omega0.getZ();
        float qw = omega0.getW();
        RodBendTwist.setOmega0(constraintVa, qx, qy, qz, qw);
        return this;
    }

    public RodBendTwist setRod(int indexInConstraint, int indexInMesh) {
        long constraintVa = this.va();
        RodBendTwist.setRod(constraintVa, indexInConstraint, indexInMesh);
        return this;
    }

    @Override
    public float getCompliance() {
        long constraintVa = this.va();
        float result = RodBendTwist.getCompliance(constraintVa);
        return result;
    }

    @Override
    public Quat getOmega0() {
        long constraintVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        RodBendTwist.getOmega0(constraintVa, storeFloats);
        Quat result = new Quat(storeFloats);
        return result;
    }

    @Override
    public int getRod(int indexInConstraint) {
        long constraintVa = this.va();
        int result = RodBendTwist.getRod(constraintVa, indexInConstraint);
        return result;
    }

    private static native long create(int var0, int var1, float var2);

    private static native long createDefault();

    private static native void free(long var0);

    private static native float getCompliance(long var0);

    private static native void getOmega0(long var0, FloatBuffer var2);

    private static native int getRod(long var0, int var2);

    private static native void setCompliance(long var0, float var2);

    private static native void setOmega0(long var0, float var2, float var3, float var4, float var5);

    private static native void setRod(long var0, int var2, int var3);
}

