/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.NonCopyable;
import com.github.stephengold.joltjni.readonly.ConstBody;
import com.github.stephengold.joltjni.readonly.ConstShape;

public class SimShapeFilter
extends NonCopyable {
    public SimShapeFilter() {
        long filterVa = SimShapeFilter.createDefault();
        this.setVirtualAddressAsOwner(filterVa);
    }

    public boolean shouldCollide(ConstBody body1, ConstShape shape1, int subShapeId1, ConstBody body2, ConstShape shape2, int subShapeId2) {
        long filterVa = this.va();
        long body1Va = body1.targetVa();
        long shape1Va = shape1.targetVa();
        long body2Va = body2.targetVa();
        long shape2Va = shape2.targetVa();
        boolean result = SimShapeFilter.shouldCollide(filterVa, body1Va, shape1Va, subShapeId1, body2Va, shape2Va, subShapeId2);
        return result;
    }

    final void setVirtualAddressAsOwner(long filterVa) {
        Runnable freeingAction = () -> SimShapeFilter.free(filterVa);
        this.setVirtualAddress(filterVa, freeingAction);
    }

    private static native long createDefault();

    private static native void free(long var0);

    private static native boolean shouldCollide(long var0, long var2, long var4, int var6, long var7, long var9, int var11);
}

