/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.Mat44Array;
import com.github.stephengold.joltjni.SkeletonMapperRef;
import com.github.stephengold.joltjni.readonly.ConstSkeleton;
import com.github.stephengold.joltjni.template.RefTarget;

public class SkeletonMapper
extends JoltPhysicsObject
implements RefTarget {
    public SkeletonMapper() {
        long mapperVa = SkeletonMapper.createDefault();
        long refVa = SkeletonMapper.toRef(mapperVa);
        Runnable freeingAction = () -> SkeletonMapperRef.free(refVa);
        this.setVirtualAddress(mapperVa, freeingAction);
    }

    SkeletonMapper(long mapperVa) {
        long refVa = SkeletonMapper.toRef(mapperVa);
        Runnable freeingAction = () -> SkeletonMapperRef.free(refVa);
        this.setVirtualAddress(mapperVa, freeingAction);
    }

    public void initialize(ConstSkeleton skeleton1, Mat44Array neutralPose1, ConstSkeleton skeleton2, Mat44Array neutralPose2) {
        long mapperVa = this.va();
        long skeleton1Va = skeleton1.targetVa();
        long pose1Va = neutralPose1.va();
        long skeleton2Va = skeleton2.targetVa();
        long pose2Va = neutralPose2.va();
        SkeletonMapper.initialize(mapperVa, skeleton1Va, pose1Va, skeleton2Va, pose2Va);
    }

    public void lockAllTranslations(ConstSkeleton skeleton2, Mat44Array neutralPose2) {
        long mapperVa = this.va();
        long skeleton2Va = skeleton2.targetVa();
        long pose2Va = neutralPose2.va();
        SkeletonMapper.lockAllTranslations(mapperVa, skeleton2Va, pose2Va);
    }

    public void map(Mat44Array pose1ModelSpace, Mat44Array pose2LocalSpace, Mat44Array storePose2ModelSpace) {
        long mapperVa = this.va();
        long pose1Va = pose1ModelSpace.va();
        long pose2LocalVa = pose2LocalSpace.va();
        long storePose2ModelVa = storePose2ModelSpace.va();
        SkeletonMapper.map(mapperVa, pose1Va, pose2LocalVa, storePose2ModelVa);
    }

    public void mapReverse(Mat44Array pose2ModelSpace, Mat44Array storePose1ModelSpace) {
        long mapperVa = this.va();
        long pose2Va = pose2ModelSpace.va();
        long storePose1Va = storePose1ModelSpace.va();
        SkeletonMapper.mapReverse(mapperVa, pose2Va, storePose1Va);
    }

    @Override
    public int getRefCount() {
        long mapperVa = this.va();
        int result = SkeletonMapper.getRefCount(mapperVa);
        return result;
    }

    @Override
    public void setEmbedded() {
        long mapperVa = this.va();
        SkeletonMapper.setEmbedded(mapperVa);
    }

    @Override
    public SkeletonMapperRef toRef() {
        long mapperVa = this.va();
        long copyVa = SkeletonMapper.toRef(mapperVa);
        SkeletonMapperRef result = new SkeletonMapperRef(copyVa, true);
        return result;
    }

    private static native long createDefault();

    private static native int getRefCount(long var0);

    private static native void initialize(long var0, long var2, long var4, long var6, long var8);

    private static native void lockAllTranslations(long var0, long var2, long var4);

    private static native void map(long var0, long var2, long var4, long var6);

    private static native void mapReverse(long var0, long var2, long var4);

    private static native void setEmbedded(long var0);

    private static native long toRef(long var0);
}

