/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.SkeletonMapper;
import com.github.stephengold.joltjni.template.Ref;

public final class SkeletonMapperRef
extends Ref {
    public SkeletonMapperRef() {
        long refVa = SkeletonMapperRef.create();
        this.setVirtualAddress(refVa, () -> SkeletonMapperRef.free(refVa));
    }

    SkeletonMapperRef(long refVa, boolean owner) {
        Runnable freeingAction = owner ? () -> SkeletonMapperRef.free(refVa) : null;
        this.setVirtualAddress(refVa, freeingAction);
    }

    @Override
    public SkeletonMapper getPtr() {
        long mapperRef = this.targetVa();
        SkeletonMapper result = new SkeletonMapper(mapperRef);
        return result;
    }

    @Override
    public long targetVa() {
        long refVa = this.va();
        long result = SkeletonMapperRef.getPtr(refVa);
        return result;
    }

    @Override
    public SkeletonMapperRef toRef() {
        long refVa = this.va();
        long copyVa = SkeletonMapperRef.copy(refVa);
        SkeletonMapperRef result = new SkeletonMapperRef(copyVa, true);
        return result;
    }

    private static native long copy(long var0);

    private static native long create();

    static native void free(long var0);

    private static native long getPtr(long var0);
}

