/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Joint;
import com.github.stephengold.joltjni.Skeleton;
import com.github.stephengold.joltjni.StreamOut;
import com.github.stephengold.joltjni.readonly.ConstSkeleton;
import com.github.stephengold.joltjni.template.Ref;

public final class SkeletonRef
extends Ref
implements ConstSkeleton {
    public SkeletonRef() {
        long refVa = SkeletonRef.createDefault();
        this.setVirtualAddress(refVa, () -> SkeletonRef.free(refVa));
    }

    SkeletonRef(long refVa, boolean owner) {
        Runnable freeingAction = owner ? () -> SkeletonRef.free(refVa) : null;
        this.setVirtualAddress(refVa, freeingAction);
    }

    @Override
    public boolean areJointsCorrectlyOrdered() {
        long skeletonVa = this.targetVa();
        boolean result = Skeleton.areJointsCorrectlyOrdered(skeletonVa);
        return result;
    }

    @Override
    public Joint getJoint(int jointIndex) {
        long skeletonVa = this.targetVa();
        long resultVa = Skeleton.getJoint(skeletonVa, jointIndex);
        Joint result = new Joint(this, resultVa);
        return result;
    }

    @Override
    public int getJointCount() {
        long skeletonVa = this.targetVa();
        int result = Skeleton.getJointCount(skeletonVa);
        return result;
    }

    @Override
    public int getJointIndex(String name) {
        long skeletonVa = this.targetVa();
        int result = Skeleton.getJointIndex(skeletonVa, name);
        return result;
    }

    public Joint[] getJoints() {
        long skeletonVa = this.targetVa();
        int numJoints = Skeleton.getJointCount(skeletonVa);
        Joint[] result = new Joint[numJoints];
        for (int i = 0; i < numJoints; ++i) {
            long jointVa = Skeleton.getJoint(skeletonVa, i);
            result[i] = new Joint(this, jointVa);
        }
        return result;
    }

    @Override
    public void saveBinaryState(StreamOut stream) {
        long skeletonVa = this.targetVa();
        long streamVa = stream.va();
        Skeleton.saveBinaryState(skeletonVa, streamVa);
    }

    @Override
    public Skeleton getPtr() {
        long skeletonVa = this.targetVa();
        Skeleton result = new Skeleton(skeletonVa);
        return result;
    }

    @Override
    public long targetVa() {
        long refVa = this.va();
        long result = SkeletonRef.getPtr(refVa);
        return result;
    }

    @Override
    public SkeletonRef toRef() {
        long refVa = this.va();
        long copyVa = SkeletonRef.copy(refVa);
        SkeletonRef result = new SkeletonRef(copyVa, true);
        return result;
    }

    private static native long copy(long var0);

    private static native long createDefault();

    static native void free(long var0);

    private static native long getPtr(long var0);
}

