/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Constraint;
import com.github.stephengold.joltjni.ConstraintSettings;
import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.StreamIn;
import com.github.stephengold.joltjni.StreamOut;
import com.github.stephengold.joltjni.enumerate.ESpringMode;
import com.github.stephengold.joltjni.readonly.ConstSpringSettings;
import com.github.stephengold.joltjni.template.Ref;
import com.github.stephengold.joltjni.template.RefTarget;

public final class SpringSettings
extends JoltPhysicsObject
implements ConstSpringSettings {
    public SpringSettings() {
        long settingsVa = SpringSettings.createDefault();
        this.setVirtualAddress(settingsVa, () -> SpringSettings.free(settingsVa));
    }

    public SpringSettings(ConstSpringSettings original) {
        long originalVa = original.targetVa();
        long copyVa = SpringSettings.createCopy(originalVa);
        this.setVirtualAddress(copyVa, () -> SpringSettings.free(copyVa));
    }

    SpringSettings(JoltPhysicsObject container, long settingsVa) {
        super(container, settingsVa);
    }

    public void restoreBinaryState(StreamIn stream) {
        long settingsVa = this.va();
        long streamVa = stream.va();
        SpringSettings.restoreBinaryState(settingsVa, streamVa);
    }

    public SpringSettings setDamping(float damping) {
        long settingsVa = this.va();
        SpringSettings.setDamping(settingsVa, damping);
        return this;
    }

    public SpringSettings setFrequency(float frequency) {
        long settingsVa = this.va();
        SpringSettings.setFrequency(settingsVa, frequency);
        return this;
    }

    public SpringSettings setMode(ESpringMode mode) {
        long settingsVa = this.va();
        int ordinal = mode.ordinal();
        SpringSettings.setMode(settingsVa, ordinal);
        return this;
    }

    public SpringSettings setStiffness(float stiffness) {
        long settingsVa = this.va();
        SpringSettings.setStiffness(settingsVa, stiffness);
        return this;
    }

    @Override
    public Constraint getConstraint() {
        RefTarget result;
        JoltPhysicsObject container = this.getContainingObject();
        if (!(container instanceof Ref)) {
            result = null;
        } else {
            result = ((Ref)container).getPtr();
            if (!(result instanceof Constraint)) {
                result = null;
            }
        }
        return (Constraint)result;
    }

    @Override
    public ConstraintSettings getConstraintSettings() {
        RefTarget result;
        JoltPhysicsObject container = this.getContainingObject();
        if (!(container instanceof Ref)) {
            result = null;
        } else {
            result = ((Ref)container).getPtr();
            if (!(result instanceof ConstraintSettings)) {
                result = null;
            }
        }
        return (ConstraintSettings)result;
    }

    @Override
    public float getDamping() {
        long settingsVa = this.va();
        float result = SpringSettings.getDamping(settingsVa);
        return result;
    }

    @Override
    public float getFrequency() {
        long settingsVa = this.va();
        float result = SpringSettings.getFrequency(settingsVa);
        return result;
    }

    @Override
    public ESpringMode getMode() {
        long settingsVa = this.va();
        int ordinal = SpringSettings.getMode(settingsVa);
        ESpringMode result = ESpringMode.values()[ordinal];
        return result;
    }

    @Override
    public float getStiffness() {
        long settingsVa = this.va();
        float result = SpringSettings.getStiffness(settingsVa);
        return result;
    }

    @Override
    public boolean hasStiffness() {
        long settingsVa = this.va();
        boolean result = SpringSettings.hasStiffness(settingsVa);
        return result;
    }

    @Override
    public void saveBinaryState(StreamOut stream) {
        long settingsVa = this.va();
        long streamVa = stream.va();
        SpringSettings.saveBinaryState(settingsVa, streamVa);
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native void free(long var0);

    private static native float getDamping(long var0);

    private static native float getFrequency(long var0);

    private static native int getMode(long var0);

    private static native float getStiffness(long var0);

    private static native boolean hasStiffness(long var0);

    private static native void restoreBinaryState(long var0, long var2);

    private static native void saveBinaryState(long var0, long var2);

    private static native void setDamping(long var0, float var2);

    private static native void setFrequency(long var0, float var2);

    private static native void setMode(long var0, int var2);

    private static native void setStiffness(long var0, float var2);
}

