/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.ConvexShapeSettings;
import com.github.stephengold.joltjni.PhysicsMaterial;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EShapeSubType;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public class TriangleShapeSettings
extends ConvexShapeSettings {
    public TriangleShapeSettings() {
        long settingsVa = TriangleShapeSettings.createDefault();
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.Triangle);
    }

    TriangleShapeSettings(long settingsVa) {
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.Triangle);
    }

    public TriangleShapeSettings(TriangleShapeSettings original) {
        long originalVa = original.va();
        long copyVa = TriangleShapeSettings.createCopy(originalVa);
        this.setVirtualAddressAsCoOwner(copyVa, EShapeSubType.Triangle);
    }

    public TriangleShapeSettings(Vec3Arg v1, Vec3Arg v2, Vec3Arg v3) {
        this(v1, v2, v3, 0.0f);
    }

    public TriangleShapeSettings(Vec3Arg v1, Vec3Arg v2, Vec3Arg v3, float convexRadius) {
        this(v1, v2, v3, convexRadius, null);
    }

    public TriangleShapeSettings(Vec3Arg v1, Vec3Arg v2, Vec3Arg v3, float convexRadius, PhysicsMaterial material) {
        float v1x = v1.getX();
        float v1y = v1.getY();
        float v1z = v1.getZ();
        float v2x = v2.getX();
        float v2y = v2.getY();
        float v2z = v2.getZ();
        float v3x = v3.getX();
        float v3y = v3.getY();
        float v3z = v3.getZ();
        long materialVa = material == null ? 0L : material.va();
        long settingsVa = TriangleShapeSettings.createTriangleShapeSettings(v1x, v1y, v1z, v2x, v2y, v2z, v3x, v3y, v3z, convexRadius, materialVa);
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.Triangle);
    }

    public float getConvexRadius() {
        long settingsVa = this.va();
        float result = TriangleShapeSettings.getConvexRadius(settingsVa);
        return result;
    }

    public Vec3 getV1() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        TriangleShapeSettings.getV1(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public Vec3 getV2() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        TriangleShapeSettings.getV2(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public Vec3 getV3() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        TriangleShapeSettings.getV3(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public void setConvexRadius(float radius) {
        long settingsVa = this.va();
        TriangleShapeSettings.setConvexRadius(settingsVa, radius);
    }

    public void setV1(float x, float y, float z) {
        long settingsVa = this.va();
        TriangleShapeSettings.setV1(settingsVa, x, y, z);
    }

    public void setV2(float x, float y, float z) {
        long settingsVa = this.va();
        TriangleShapeSettings.setV2(settingsVa, x, y, z);
    }

    public void setV3(float x, float y, float z) {
        long settingsVa = this.va();
        TriangleShapeSettings.setV3(settingsVa, x, y, z);
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native long createTriangleShapeSettings(float var0, float var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, long var10);

    private static native float getConvexRadius(long var0);

    private static native void getV1(long var0, FloatBuffer var2);

    private static native void getV2(long var0, FloatBuffer var2);

    private static native void getV3(long var0, FloatBuffer var2);

    private static native void setConvexRadius(long var0, float var2);

    private static native void setV1(long var0, float var2, float var3, float var4);

    private static native void setV2(long var0, float var2, float var3, float var4);

    private static native void setV3(long var0, float var2, float var3, float var4);
}

