/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Body;
import com.github.stephengold.joltjni.Constraint;
import com.github.stephengold.joltjni.Mat44;
import com.github.stephengold.joltjni.TwoBodyConstraintRef;
import com.github.stephengold.joltjni.readonly.ConstTwoBodyConstraint;
import java.nio.DoubleBuffer;

public abstract class TwoBodyConstraint
extends Constraint
implements ConstTwoBodyConstraint {
    TwoBodyConstraint() {
    }

    @Override
    public TwoBodyConstraintRef toRef() {
        long constraintVa = this.va();
        long refVa = TwoBodyConstraint.toRef(constraintVa);
        TwoBodyConstraintRef result = new TwoBodyConstraintRef(refVa, true);
        return result;
    }

    @Override
    public Body getBody1() {
        long constraintVa = this.va();
        long bodyVa = TwoBodyConstraint.getBody1(constraintVa);
        Body result = new Body(bodyVa);
        return result;
    }

    @Override
    public void getBody1PivotLocation(DoubleBuffer storeResult) {
        long constraintVa = this.va();
        TwoBodyConstraint.getBody1PivotLocation(constraintVa, storeResult);
    }

    @Override
    public Body getBody2() {
        long constraintVa = this.va();
        long bodyVa = TwoBodyConstraint.getBody2(constraintVa);
        Body result = new Body(bodyVa);
        return result;
    }

    @Override
    public void getBody2PivotLocation(DoubleBuffer storeResult) {
        long constraintVa = this.va();
        TwoBodyConstraint.getBody2PivotLocation(constraintVa, storeResult);
    }

    @Override
    public Mat44 getConstraintToBody1Matrix() {
        long constraintVa = this.va();
        long matrixVa = TwoBodyConstraint.getConstraintToBody1Matrix(constraintVa);
        Mat44 result = new Mat44(matrixVa, true);
        return result;
    }

    @Override
    public Mat44 getConstraintToBody2Matrix() {
        long constraintVa = this.va();
        long matrixVa = TwoBodyConstraint.getConstraintToBody2Matrix(constraintVa);
        Mat44 result = new Mat44(matrixVa, true);
        return result;
    }

    static native long getBody1(long var0);

    static native void getBody1PivotLocation(long var0, DoubleBuffer var2);

    static native long getBody2(long var0);

    static native void getBody2PivotLocation(long var0, DoubleBuffer var2);

    static native long getConstraintToBody1Matrix(long var0);

    static native long getConstraintToBody2Matrix(long var0);

    private static native long toRef(long var0);
}

