/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Body;
import com.github.stephengold.joltjni.Constraint;
import com.github.stephengold.joltjni.ConstraintSettings;
import com.github.stephengold.joltjni.TwoBodyConstraint;
import com.github.stephengold.joltjni.TwoBodyConstraintSettingsRef;

public abstract class TwoBodyConstraintSettings
extends ConstraintSettings {
    TwoBodyConstraintSettings() {
    }

    public TwoBodyConstraint create(Body rigidBody1, Body rigidBody2) {
        long settingsVa = this.va();
        long body1Va = rigidBody1.va();
        assert (!Body.isSoftBody(body1Va)) : "body1 must be a rigid body.";
        long body2Va = rigidBody2.va();
        assert (!Body.isSoftBody(body2Va)) : "body2 must be a rigid body.";
        long constraintVa = TwoBodyConstraintSettings.createConstraint(settingsVa, body1Va, body2Va);
        TwoBodyConstraint result = (TwoBodyConstraint)Constraint.newConstraint(constraintVa);
        return result;
    }

    @Override
    public TwoBodyConstraintSettingsRef toRef() {
        long settingsVa = this.va();
        long refVa = TwoBodyConstraintSettings.toRef(settingsVa);
        TwoBodyConstraintSettingsRef result = new TwoBodyConstraintSettingsRef(refVa, true);
        return result;
    }

    static native long createConstraint(long var0, long var2, long var4);

    private static native long toRef(long var0);
}

