/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Float3;
import com.github.stephengold.joltjni.Jolt;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.UVec4;
import com.github.stephengold.joltjni.operator.Op;
import com.github.stephengold.joltjni.readonly.Mat44Arg;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.UVec4Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import com.github.stephengold.joltjni.std.RandomNumberEngine;
import com.github.stephengold.joltjni.std.UniformFloatDistribution;
import java.nio.FloatBuffer;
import java.util.Objects;

public final class Vec3
implements Vec3Arg {
    private float x;
    private float y;
    private float z;
    private static UniformFloatDistribution distro;

    public Vec3() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public Vec3(double x, double y, double z) {
        this.x = (float)x;
        this.y = (float)y;
        this.z = (float)z;
    }

    public Vec3(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec3(float[] array) {
        this.x = array[0];
        this.y = array[1];
        this.z = array[2];
    }

    public Vec3(Float3 float3) {
        this.x = float3.x;
        this.y = float3.y;
        this.z = float3.z;
    }

    public Vec3(FloatBuffer buffer) {
        this.x = buffer.get(0);
        this.y = buffer.get(1);
        this.z = buffer.get(2);
    }

    public Vec3(RVec3Arg vec) {
        this.x = vec.x();
        this.y = vec.y();
        this.z = vec.z();
    }

    public Vec3(Vec3Arg vec) {
        this.x = vec.getX();
        this.y = vec.getY();
        this.z = vec.getZ();
    }

    public void addInPlace(float xOffset, float yOffset, float zOffset) {
        this.x += xOffset;
        this.y += yOffset;
        this.z += zOffset;
    }

    public void loadOne() {
        this.x = 1.0f;
        this.y = 1.0f;
        this.z = 1.0f;
    }

    public void loadZero() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public void normalizeInPlace() {
        float invLength = 1.0f / this.length();
        this.x *= invLength;
        this.y *= invLength;
        this.z *= invLength;
    }

    public void rotateInPlace(QuatArg rotation) {
        assert (rotation.isNormalized());
        float lw = rotation.getW();
        float lx = rotation.getX();
        float ly = rotation.getY();
        float lz = rotation.getZ();
        float rx = this.x;
        float ry = this.y;
        float rz = this.z;
        float aw = -lx * rx - ly * ry - lz * rz;
        float ax = lw * rx + ly * rz - lz * ry;
        float ay = lw * ry - lx * rz + lz * rx;
        float az = lw * rz + lx * ry - ly * rx;
        this.x = -aw * lx + ax * lw - ay * lz + az * ly;
        this.y = -aw * ly + ax * lz + ay * lw - az * lx;
        this.z = -aw * lz - ax * ly + ay * lx + az * lw;
    }

    public static Vec3 sAnd(Vec3Arg v1, Vec3Arg v2) {
        int x1 = Float.floatToRawIntBits(v1.getX());
        int x2 = Float.floatToRawIntBits(v2.getX());
        float ax = Float.intBitsToFloat(x1 & x2);
        int y1 = Float.floatToRawIntBits(v1.getY());
        int y2 = Float.floatToRawIntBits(v2.getY());
        float ay = Float.intBitsToFloat(y1 & y2);
        int z1 = Float.floatToRawIntBits(v1.getZ());
        int z2 = Float.floatToRawIntBits(v2.getZ());
        float az = Float.intBitsToFloat(z1 & z2);
        Vec3 result = new Vec3(ax, ay, az);
        return result;
    }

    public static Vec3 sAxisX() {
        Vec3 result = new Vec3(1.0f, 0.0f, 0.0f);
        return result;
    }

    public static Vec3 sAxisY() {
        Vec3 result = new Vec3(0.0f, 1.0f, 0.0f);
        return result;
    }

    public static Vec3 sAxisZ() {
        Vec3 result = new Vec3(0.0f, 0.0f, 1.0f);
        return result;
    }

    public void scaleInPlace(float scale) {
        this.x *= scale;
        this.y *= scale;
        this.z *= scale;
    }

    public void scaleInPlace(float xScale, float yScale, float zScale) {
        this.x *= xScale;
        this.y *= yScale;
        this.z *= zScale;
    }

    public void set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void set(float[] array) {
        this.x = array[0];
        this.y = array[1];
        this.z = array[2];
    }

    public void set(FloatBuffer buffer) {
        this.x = buffer.get(0);
        this.y = buffer.get(1);
        this.z = buffer.get(2);
    }

    public void set(FloatBuffer buffer, int startPos) {
        this.x = buffer.get(startPos);
        this.y = buffer.get(startPos + 1);
        this.z = buffer.get(startPos + 2);
    }

    public void set(RVec3Arg source) {
        this.x = source.x();
        this.y = source.y();
        this.z = source.z();
    }

    public void set(Vec3Arg source) {
        this.x = source.getX();
        this.y = source.getY();
        this.z = source.getZ();
    }

    public Vec3 setX(float x) {
        this.x = x;
        return this;
    }

    public Vec3 setY(float y) {
        this.y = y;
        return this;
    }

    public Vec3 setZ(float z) {
        this.z = z;
        return this;
    }

    public static UVec4 sGreater(Vec3Arg v1, Vec3Arg v2) {
        int x = v1.getX() > v2.getX() ? -1 : 0;
        int y = v1.getY() > v2.getY() ? -1 : 0;
        int z = v1.getZ() > v2.getZ() ? -1 : 0;
        UVec4 result = new UVec4(x, y, z, z);
        return result;
    }

    public static UVec4 sGreaterOrEqual(Vec3Arg v1, Vec3Arg v2) {
        int x = v1.getX() >= v2.getX() ? -1 : 0;
        int y = v1.getY() >= v2.getY() ? -1 : 0;
        int z = v1.getZ() >= v2.getZ() ? -1 : 0;
        UVec4 result = new UVec4(x, y, z, z);
        return result;
    }

    public static UVec4 sLess(Vec3Arg v1, Vec3Arg v2) {
        int x = v1.getX() < v2.getX() ? -1 : 0;
        int y = v1.getY() < v2.getY() ? -1 : 0;
        int z = v1.getZ() < v2.getZ() ? -1 : 0;
        UVec4 result = new UVec4(x, y, z, z);
        return result;
    }

    public static UVec4 sLessOrEqual(Vec3Arg v1, Vec3Arg v2) {
        int x = v1.getX() <= v2.getX() ? -1 : 0;
        int y = v1.getY() <= v2.getY() ? -1 : 0;
        int z = v1.getZ() <= v2.getZ() ? -1 : 0;
        UVec4 result = new UVec4(x, y, z, z);
        return result;
    }

    public static Vec3 sOne() {
        Vec3 result = new Vec3(1.0f, 1.0f, 1.0f);
        return result;
    }

    public void splatX() {
        this.y = this.x;
        this.z = this.x;
    }

    public void splatY() {
        this.x = this.y;
        this.z = this.y;
    }

    public void splatZ() {
        this.x = this.z;
        this.y = this.z;
    }

    public static Vec3 sRandom(RandomNumberEngine engine) {
        assert (engine != null);
        if (distro == null) {
            distro = new UniformFloatDistribution(0.0f, 1.0f);
        }
        float theta = (float)Math.PI * distro.nextFloat(engine);
        float phi = (float)Math.PI * 2 * distro.nextFloat(engine);
        Vec3 result = Vec3.sUnitSpherical(theta, phi);
        return result;
    }

    public static Vec3 sReplicate(float value) {
        Vec3 result = new Vec3(value, value, value);
        return result;
    }

    public static Vec3 sSelect(Vec3Arg notSet, Vec3Arg set, UVec4Arg control) {
        float x = control.getX() == 0 ? notSet.getX() : set.getX();
        float y = control.getY() == 0 ? notSet.getY() : set.getY();
        float z = control.getZ() == 0 ? notSet.getZ() : set.getZ();
        Vec3 result = new Vec3(x, y, z);
        return result;
    }

    public void standardizeInPlace() {
        if (Float.compare(this.x, -0.0f) == 0) {
            this.x = 0.0f;
        }
        if (Float.compare(this.y, -0.0f) == 0) {
            this.y = 0.0f;
        }
        if (Float.compare(this.z, -0.0f) == 0) {
            this.z = 0.0f;
        }
    }

    public static Vec3 sum(Vec3Arg ... vArray) {
        Vec3 result = new Vec3();
        for (Vec3Arg arg : vArray) {
            Op.plusEquals(result, arg);
        }
        return result;
    }

    public static Vec3 sUnitSpherical(float theta, float phi) {
        float sinTheta = Jolt.sin(theta);
        float vx = sinTheta * Jolt.cos(phi);
        float vy = sinTheta * Jolt.sin(phi);
        float vz = Jolt.cos(theta);
        Vec3 result = new Vec3(vx, vy, vz);
        return result;
    }

    public static Vec3 sZero() {
        Vec3 result = new Vec3();
        return result;
    }

    public void transformInPlace(Mat44Arg matrix) {
        matrix.multiply3x4InPlace(this);
    }

    @Override
    public Vec3 abs() {
        Vec3 result = new Vec3(Math.abs(this.x), Math.abs(this.y), Math.abs(this.z));
        return result;
    }

    @Override
    public void copyTo(FloatBuffer storeFloats) {
        storeFloats.put(0, this.x);
        storeFloats.put(1, this.y);
        storeFloats.put(2, this.z);
    }

    @Override
    public void copyTo(FloatBuffer storeFloats, int startPos) {
        storeFloats.put(startPos, this.x);
        storeFloats.put(startPos + 1, this.y);
        storeFloats.put(startPos + 2, this.z);
    }

    @Override
    public Vec3 cross(Vec3Arg rightFactor) {
        float rx = rightFactor.getX();
        float ry = rightFactor.getY();
        float rz = rightFactor.getZ();
        float px = this.y * rz - this.z * ry;
        float py = this.z * rx - this.x * rz;
        float pz = this.x * ry - this.y * rx;
        Vec3 result = new Vec3(px, py, pz);
        return result;
    }

    @Override
    public float dot(Vec3Arg factor) {
        float result = this.x * factor.getX() + this.y * factor.getY() + this.z * factor.getZ();
        return result;
    }

    @Override
    public float get(int index) {
        switch (index) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IllegalArgumentException("index must be 0, 1 or 2");
    }

    @Override
    public Vec3 getNormalizedPerpendicular() {
        if (Math.abs(this.x) > Math.abs(this.y)) {
            float len = (float)Math.sqrt(this.x * this.x + this.z * this.z);
            return new Vec3(this.z / len, 0.0f, -this.x / len);
        }
        float len = (float)Math.sqrt(this.y * this.y + this.z * this.z);
        return new Vec3(0.0f, this.z / len, -this.y / len);
    }

    @Override
    public Vec3 getSign() {
        float sx = this.x < 0.0f ? -1.0f : 1.0f;
        float sy = this.y < 0.0f ? -1.0f : 1.0f;
        float sz = this.z < 0.0f ? -1.0f : 1.0f;
        Vec3 result = new Vec3(sx, sy, sz);
        return result;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public float getZ() {
        return this.z;
    }

    @Override
    public boolean isFinite() {
        boolean result = Float.isFinite(this.x) && Float.isFinite(this.y) && Float.isFinite(this.z);
        return result;
    }

    @Override
    public boolean isNan() {
        boolean result = Float.isNaN(this.x) || Float.isNaN(this.y) || Float.isNaN(this.z);
        return result;
    }

    @Override
    public boolean isNearZero() {
        boolean result = this.isNearZero(1.0E-12f);
        return result;
    }

    @Override
    public boolean isNearZero(float tolerance) {
        float lengthSq = this.lengthSq();
        return lengthSq <= tolerance;
    }

    @Override
    public boolean isNormalized() {
        boolean result = this.isNormalized(1.0E-6f);
        return result;
    }

    @Override
    public boolean isNormalized(float tolerance) {
        float lengthSq = this.lengthSq();
        return Math.abs(lengthSq - 1.0f) <= tolerance;
    }

    @Override
    public boolean isClose(Vec3Arg v2, float maxDistSq) {
        double dz;
        double dy;
        double dx = v2.getX() - this.x;
        double distanceSquared = dx * dx + (dy = (double)(v2.getY() - this.y)) * dy + (dz = (double)(v2.getX() - this.z)) * dz;
        return distanceSquared <= (double)maxDistSq;
    }

    @Override
    public float length() {
        float lengthSq = this.lengthSq();
        float result = (float)Math.sqrt(lengthSq);
        return result;
    }

    @Override
    public float lengthSq() {
        float result = this.x * this.x + this.y * this.y + this.z * this.z;
        return result;
    }

    @Override
    public Vec3 normalized() {
        Vec3 result = Op.star(1.0f / this.length(), (Vec3Arg)this);
        return result;
    }

    @Override
    public Vec3 normalizedOr(Vec3Arg zeroValue) {
        float length;
        float lengthSq = this.lengthSq();
        Vec3 result = lengthSq == 0.0f ? new Vec3(zeroValue) : ((length = (float)Math.sqrt(lengthSq)) == 0.0f ? new Vec3(zeroValue) : Op.star(1.0f / length, (Vec3Arg)this));
        return result;
    }

    @Override
    public void put(FloatBuffer storeBuffer) {
        storeBuffer.put(this.x);
        storeBuffer.put(this.y);
        storeBuffer.put(this.z);
    }

    @Override
    public Vec3 reciprocal() {
        Vec3 result = new Vec3(1.0f / this.x, 1.0f / this.y, 1.0f / this.z);
        return result;
    }

    @Override
    public float reduceMax() {
        float result = Math.max(Math.max(this.x, this.y), this.z);
        return result;
    }

    @Override
    public float reduceMin() {
        float result = Math.min(Math.min(this.x, this.y), this.z);
        return result;
    }

    @Override
    public void storeFloat3(Float3 target) {
        target.x = this.x;
        target.y = this.y;
        target.z = this.z;
    }

    @Override
    public Vec3 swizzle(int xi, int yi, int zi) {
        float rx = this.get(xi);
        float ry = this.get(yi);
        float rz = this.get(zi);
        Vec3 result = new Vec3(rx, ry, rz);
        return result;
    }

    @Override
    public float[] toArray() {
        float[] result = new float[]{this.x, this.y, this.z};
        return result;
    }

    @Override
    public FloatBuffer toBuffer() {
        FloatBuffer result = Jolt.newDirectFloatBuffer(3);
        this.copyTo(result);
        return result;
    }

    @Override
    public RVec3 toRVec3() {
        RVec3 result = new RVec3(this.x, this.y, this.z);
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        Vec3Arg otherVector = (Vec3Arg)other;
        if (Float.compare(this.x, otherVector.getX()) != 0) {
            return false;
        }
        if (Float.compare(this.y, otherVector.getY()) != 0) {
            return false;
        }
        return Float.compare(this.z, otherVector.getZ()) == 0;
    }

    public int hashCode() {
        int result = Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z));
        return result;
    }

    public String toString() {
        String result = "Vec3(" + this.x + " " + this.y + " " + this.z + ")";
        return result;
    }
}

