/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;

public class VehicleDifferentialSettings
extends JoltPhysicsObject {
    public VehicleDifferentialSettings() {
        long settingsVa = VehicleDifferentialSettings.createDefault();
        this.setVirtualAddress(settingsVa, () -> VehicleDifferentialSettings.free(settingsVa));
    }

    VehicleDifferentialSettings(JoltPhysicsObject container, long settingsVa) {
        super(container, settingsVa);
    }

    public VehicleDifferentialSettings(VehicleDifferentialSettings original) {
        long originalVa = original.va();
        long copyVa = VehicleDifferentialSettings.createCopy(originalVa);
        this.setVirtualAddress(copyVa, () -> VehicleDifferentialSettings.free(copyVa));
    }

    public float getDifferentialRatio() {
        long settingsVa = this.va();
        float result = VehicleDifferentialSettings.getDifferentialRatio(settingsVa);
        return result;
    }

    public float getEngineTorqueRatio() {
        long settingsVa = this.va();
        float result = VehicleDifferentialSettings.getEngineTorqueRatio(settingsVa);
        return result;
    }

    public int getLeftWheel() {
        long settingsVa = this.va();
        int result = VehicleDifferentialSettings.getLeftWheel(settingsVa);
        return result;
    }

    public float getLimitedSlipRatio() {
        long settingsVa = this.va();
        float result = VehicleDifferentialSettings.getLimitedSlipRatio(settingsVa);
        return result;
    }

    public int getRightWheel() {
        long settingsVa = this.va();
        int result = VehicleDifferentialSettings.getRightWheel(settingsVa);
        return result;
    }

    public void setDifferentialRatio(float ratio) {
        long settingsVa = this.va();
        VehicleDifferentialSettings.setDifferentialRatio(settingsVa, ratio);
    }

    public float setEngineTorqueRatio(float fraction) {
        long settingsVa = this.va();
        VehicleDifferentialSettings.setEngineTorqueRatio(settingsVa, fraction);
        return fraction;
    }

    public void setLeftWheel(int wheelIndex) {
        long settingsVa = this.va();
        VehicleDifferentialSettings.setLeftWheel(settingsVa, wheelIndex);
    }

    public void setLimitedSlipRatio(float ratio) {
        long settingsVa = this.va();
        VehicleDifferentialSettings.setLimitedSlipRatio(settingsVa, ratio);
    }

    public void setRightWheel(int wheelIndex) {
        long settingsVa = this.va();
        VehicleDifferentialSettings.setRightWheel(settingsVa, wheelIndex);
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native void free(long var0);

    private static native float getDifferentialRatio(long var0);

    private static native float getEngineTorqueRatio(long var0);

    private static native int getLeftWheel(long var0);

    private static native float getLimitedSlipRatio(long var0);

    private static native int getRightWheel(long var0);

    private static native void setDifferentialRatio(long var0, float var2);

    private static native void setEngineTorqueRatio(long var0, float var2);

    private static native void setLeftWheel(long var0, int var2);

    private static native void setLimitedSlipRatio(long var0, float var2);

    private static native void setRightWheel(long var0, int var2);
}

