/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.NonCopyable;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.VehicleConstraintRef;
import com.github.stephengold.joltjni.WheelSettings;
import com.github.stephengold.joltjni.WheelTv;
import com.github.stephengold.joltjni.WheelWv;
import com.github.stephengold.joltjni.readonly.ConstWheel;
import com.github.stephengold.joltjni.readonly.ConstWheelSettings;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;

public class Wheel
extends NonCopyable
implements ConstWheel {
    Wheel(VehicleConstraintRef container, long wheelVa) {
        super(container, wheelVa);
    }

    static Wheel newWheel(long wheelVa, int ordinal, VehicleConstraintRef containerRef) {
        Wheel result;
        if (wheelVa == 0L) {
            return null;
        }
        switch (ordinal) {
            case 2: 
            case 4: {
                result = new WheelWv(containerRef, wheelVa);
                break;
            }
            case 3: {
                result = new WheelTv(containerRef, wheelVa);
                break;
            }
            default: {
                throw new IllegalArgumentException("ordinal = " + ordinal);
            }
        }
        return result;
    }

    @Override
    public float getAngularVelocity() {
        long wheelVa = this.va();
        float result = Wheel.getAngularVelocity(wheelVa);
        return result;
    }

    @Override
    public int getContactBodyId() {
        long wheelVa = this.va();
        int result = Wheel.getContactBodyId(wheelVa);
        return result;
    }

    @Override
    public Vec3 getContactLateral() {
        long wheelVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        Wheel.getContactLateral(wheelVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public Vec3 getContactLongitudinal() {
        long wheelVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        Wheel.getContactLongitudinal(wheelVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public Vec3 getContactNormal() {
        long wheelVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        Wheel.getContactNormal(wheelVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public Vec3 getContactPointVelocity() {
        long wheelVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        Wheel.getContactPointVelocity(wheelVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public RVec3 getContactPosition() {
        long wheelVa = this.va();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        Wheel.getContactPosition(wheelVa, storeDoubles);
        RVec3 result = new RVec3(storeDoubles);
        return result;
    }

    @Override
    public int getContactSubShapeId() {
        long wheelVa = this.va();
        int result = Wheel.getContactSubShapeId(wheelVa);
        return result;
    }

    @Override
    public float getLateralLambda() {
        long wheelVa = this.va();
        float result = Wheel.getLateralLambda(wheelVa);
        return result;
    }

    @Override
    public float getLongitudinalLambda() {
        long wheelVa = this.va();
        float result = Wheel.getLongitudinalLambda(wheelVa);
        return result;
    }

    @Override
    public float getRotationAngle() {
        long wheelVa = this.va();
        float result = Wheel.getRotationAngle(wheelVa);
        return result;
    }

    @Override
    public ConstWheelSettings getSettings() {
        long wheelVa = this.va();
        long settingsVa = Wheel.getSettings(wheelVa);
        WheelSettings result = WheelSettings.newSettings(settingsVa);
        return result;
    }

    @Override
    public float getSteerAngle() {
        long wheelVa = this.va();
        float result = Wheel.getSteerAngle(wheelVa);
        return result;
    }

    @Override
    public float getSuspensionLambda() {
        long wheelVa = this.va();
        float result = Wheel.getSuspensionLambda(wheelVa);
        return result;
    }

    @Override
    public float getSuspensionLength() {
        long wheelVa = this.va();
        float result = Wheel.getSuspensionLength(wheelVa);
        return result;
    }

    @Override
    public boolean hasContact() {
        long wheelVa = this.va();
        boolean result = Wheel.hasContact(wheelVa);
        return result;
    }

    @Override
    public boolean hasHitHardPoint() {
        long wheelVa = this.va();
        boolean result = Wheel.hasHitHardPoint(wheelVa);
        return result;
    }

    private static native float getAngularVelocity(long var0);

    private static native int getContactBodyId(long var0);

    private static native void getContactLateral(long var0, FloatBuffer var2);

    private static native void getContactLongitudinal(long var0, FloatBuffer var2);

    private static native void getContactNormal(long var0, FloatBuffer var2);

    private static native void getContactPointVelocity(long var0, FloatBuffer var2);

    private static native void getContactPosition(long var0, DoubleBuffer var2);

    private static native int getContactSubShapeId(long var0);

    private static native float getLateralLambda(long var0);

    private static native float getLongitudinalLambda(long var0);

    private static native float getRotationAngle(long var0);

    private static native long getSettings(long var0);

    private static native float getSteerAngle(long var0);

    private static native float getSuspensionLambda(long var0);

    private static native float getSuspensionLength(long var0);

    private static native boolean hasContact(long var0);

    private static native boolean hasHitHardPoint(long var0);
}

