/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni.operator;

import com.github.stephengold.joltjni.Color;
import com.github.stephengold.joltjni.Float3;
import com.github.stephengold.joltjni.Mat44;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RMat44;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.ConstColor;
import com.github.stephengold.joltjni.readonly.Mat44Arg;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.RMat44Arg;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;

public final class Op {
    private Op() {
    }

    public static ConstColor assign(Color left, ConstColor right) {
        left.set(right);
        return right;
    }

    public static Mat44Arg assign(Mat44 left, Mat44Arg right) {
        left.set(right);
        return right;
    }

    public static RMat44Arg assign(RMat44 left, RMat44Arg right) {
        left.set(right);
        return right;
    }

    public static RVec3Arg assign(RVec3 left, RVec3Arg right) {
        double rx = right.xx();
        double ry = right.yy();
        double rz = right.zz();
        left.set(rx, ry, rz);
        return right;
    }

    public static Vec3Arg assign(Vec3 left, Vec3Arg right) {
        float rx = right.getX();
        float ry = right.getY();
        float rz = right.getZ();
        left.set(rx, ry, rz);
        return right;
    }

    public static boolean isEqual(ConstColor left, ConstColor right) {
        boolean result = left.getA() == right.getA() && left.getB() == right.getB() && left.getG() == right.getG() && left.getR() == right.getR();
        return result;
    }

    public static boolean isEqual(Mat44Arg left, Mat44Arg right) {
        boolean result = left.isEqual(right);
        return result;
    }

    public static RVec3 minus(RVec3Arg right) {
        double xx = -right.xx();
        double yy = -right.yy();
        double zz = -right.zz();
        RVec3 result = new RVec3(xx, yy, zz);
        return result;
    }

    public static RVec3 minus(RVec3Arg left, RVec3Arg right) {
        double xx = left.xx() - right.xx();
        double yy = left.yy() - right.yy();
        double zz = left.zz() - right.zz();
        RVec3 result = new RVec3(xx, yy, zz);
        return result;
    }

    public static RVec3 minus(RVec3Arg left, Vec3Arg right) {
        double xx = left.xx() - (double)right.getX();
        double yy = left.yy() - (double)right.getY();
        double zz = left.zz() - (double)right.getZ();
        RVec3 result = new RVec3(xx, yy, zz);
        return result;
    }

    public static Vec3 minus(Vec3Arg right) {
        float x = -right.getX();
        float y = -right.getY();
        float z = -right.getZ();
        Vec3 result = new Vec3(x, y, z);
        return result;
    }

    public static Vec3 minus(Vec3Arg left, Vec3Arg right) {
        float x = left.getX() - right.getX();
        float y = left.getY() - right.getY();
        float z = left.getZ() - right.getZ();
        Vec3 result = new Vec3(x, y, z);
        return result;
    }

    public static void minusEquals(Vec3 left, Vec3Arg right) {
        left.setX(left.getX() - right.getX());
        left.setY(left.getY() - right.getY());
        left.setZ(left.getZ() - right.getZ());
    }

    public static boolean notEqual(ConstColor left, ConstColor right) {
        boolean result = left.getA() != right.getA() || left.getB() != right.getB() || left.getG() != right.getG() || left.getR() != right.getR();
        return result;
    }

    public static RVec3 plus(RVec3Arg left, Float3 right) {
        double xx = left.xx() + (double)right.x;
        double yy = left.yy() + (double)right.y;
        double zz = left.zz() + (double)right.z;
        RVec3 result = new RVec3(xx, yy, zz);
        return result;
    }

    public static RVec3 plus(RVec3Arg left, RVec3Arg right) {
        double xx = left.xx() + right.xx();
        double yy = left.yy() + right.yy();
        double zz = left.zz() + right.zz();
        RVec3 result = new RVec3(xx, yy, zz);
        return result;
    }

    public static RVec3 plus(RVec3Arg left, Vec3Arg right) {
        double xx = left.xx() + (double)right.getX();
        double yy = left.yy() + (double)right.getY();
        double zz = left.zz() + (double)right.getZ();
        RVec3 result = new RVec3(xx, yy, zz);
        return result;
    }

    public static RVec3 plus(Vec3Arg left, RVec3Arg right) {
        double xx = (double)left.getX() + right.xx();
        double yy = (double)left.getY() + right.yy();
        double zz = (double)left.getZ() + right.zz();
        RVec3 result = new RVec3(xx, yy, zz);
        return result;
    }

    public static Vec3 plus(Vec3Arg left, Vec3Arg right) {
        float x = left.getX() + right.getX();
        float y = left.getY() + right.getY();
        float z = left.getZ() + right.getZ();
        Vec3 result = new Vec3(x, y, z);
        return result;
    }

    public static void plusEquals(RVec3 left, RVec3Arg right) {
        double xx = left.xx() + right.xx();
        double yy = left.yy() + right.yy();
        double zz = left.zz() + right.zz();
        left.set(xx, yy, zz);
    }

    public static void plusEquals(RVec3 left, Vec3Arg right) {
        double xx = left.xx() + (double)right.getX();
        double yy = left.yy() + (double)right.getY();
        double zz = left.zz() + (double)right.getZ();
        left.set(xx, yy, zz);
    }

    public static void plusEquals(Vec3 left, RVec3Arg right) {
        left.setX(left.getX() + right.x());
        left.setY(left.getY() + right.y());
        left.setZ(left.getZ() + right.z());
    }

    public static void plusEquals(Vec3 left, Vec3Arg right) {
        left.setX(left.getX() + right.getX());
        left.setY(left.getY() + right.getY());
        left.setZ(left.getZ() + right.getZ());
    }

    public static RVec3 slash(RVec3Arg left, double right) {
        double xx = left.xx() / right;
        double yy = left.yy() / right;
        double zz = left.zz() / right;
        RVec3 result = new RVec3(xx, yy, zz);
        return result;
    }

    public static Vec3 slash(Vec3Arg left, float right) {
        float x = left.getX() / right;
        float y = left.getY() / right;
        float z = left.getZ() / right;
        Vec3 result = new Vec3(x, y, z);
        return result;
    }

    public static void slashEquals(RVec3 left, double right) {
        double xx = left.xx() / right;
        double yy = left.yy() / right;
        double zz = left.zz() / right;
        left.set(xx, yy, zz);
    }

    public static void slashEquals(Vec3 left, float right) {
        float xx = left.getX() / right;
        float yy = left.getY() / right;
        float zz = left.getZ() / right;
        left.set(xx, yy, zz);
    }

    public static RVec3 star(double left, RVec3Arg right) {
        double x = left * right.xx();
        double y = left * right.yy();
        double z = left * right.zz();
        RVec3 result = new RVec3(x, y, z);
        return result;
    }

    public static Quat star(float left, QuatArg right) {
        float w = left * right.getW();
        float x = left * right.getX();
        float y = left * right.getY();
        float z = left * right.getZ();
        Quat result = new Quat(x, y, z, w);
        return result;
    }

    public static Vec3 star(float left, Vec3Arg right) {
        float x = left * right.getX();
        float y = left * right.getY();
        float z = left * right.getZ();
        Vec3 result = new Vec3(x, y, z);
        return result;
    }

    public static Vec3 star(Mat44Arg left, Vec3Arg right) {
        Vec3 result = left.multiply3x4(right);
        return result;
    }

    public static Mat44 star(Mat44Arg left, Mat44Arg right) {
        Mat44 result = left.multiply(right);
        return result;
    }

    public static Quat star(QuatArg left, QuatArg right) {
        float lw = left.getW();
        float lx = left.getX();
        float ly = left.getY();
        float lz = left.getZ();
        float rw = right.getW();
        float rx = right.getX();
        float ry = right.getY();
        float rz = right.getZ();
        float w = lw * rw - lx * rx - ly * ry - lz * rz;
        float x = lw * rx + lx * rw + ly * rz - lz * ry;
        float y = lw * ry - lx * rz + ly * rw + lz * rx;
        float z = lw * rz + lx * ry - ly * rx + lz * rw;
        Quat result = new Quat(x, y, z, w);
        return result;
    }

    public static Vec3 star(QuatArg left, Vec3Arg right) {
        assert (left.isNormalized());
        float lw = left.getW();
        float lx = left.getX();
        float ly = left.getY();
        float lz = left.getZ();
        float rx = right.getX();
        float ry = right.getY();
        float rz = right.getZ();
        float aw = -lx * rx - ly * ry - lz * rz;
        float ax = lw * rx + ly * rz - lz * ry;
        float ay = lw * ry - lx * rz + lz * rx;
        float az = lw * rz + lx * ry - ly * rx;
        float x = -aw * lx + ax * lw - ay * lz + az * ly;
        float y = -aw * ly + ax * lz + ay * lw - az * lx;
        float z = -aw * lz - ax * ly + ay * lx + az * lw;
        Vec3 result = new Vec3(x, y, z);
        return result;
    }

    public static RMat44 star(RMat44Arg left, Mat44Arg right) {
        RMat44 result = left.multiply(right);
        return result;
    }

    public static RMat44 star(RMat44Arg left, RMat44Arg right) {
        RMat44 result = left.multiply(right);
        return result;
    }

    public static RVec3 star(RMat44Arg left, RVec3Arg right) {
        RVec3 result = left.multiply3x4(right);
        return result;
    }

    public static RVec3 star(RMat44Arg left, Vec3Arg right) {
        RVec3 result = left.multiply3x4(right);
        return result;
    }

    public static Vec3 star(Vec3Arg left, float right) {
        Vec3 result = Op.star(right, left);
        return result;
    }

    public static Vec3 star(Vec3Arg left, QuatArg right) {
        assert (right.isNormalized());
        float lx = left.getX();
        float ly = left.getY();
        float lz = left.getZ();
        float rw = right.getW();
        float rx = right.getX();
        float ry = right.getY();
        float rz = right.getZ();
        float aw = -lx * rx - ly * ry - lz * rz;
        float ax = lx * rw + ly * rz - lz * ry;
        float ay = ly * rw - lx * rz + lz * rx;
        float az = lz * rw + lx * ry - ly * rx;
        float x = rw * ax - rx * aw - ry * az + rz * ay;
        float y = rw * ay + rx * az - ry * aw - rz * ax;
        float z = rw * az - rx * ay + ry * ax - rz * aw;
        Vec3 result = new Vec3(x, y, z);
        return result;
    }

    public static Vec3 star(Vec3Arg left, Vec3Arg right) {
        float x = left.getX() * right.getX();
        float y = left.getY() * right.getY();
        float z = left.getZ() * right.getZ();
        Vec3 result = new Vec3(x, y, z);
        return result;
    }

    public static void starEquals(Vec3 left, float right) {
        left.setX(left.getX() * right);
        left.setY(left.getY() * right);
        left.setZ(left.getZ() * right);
    }
}

