/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.builtin.cloth;

import java.util.function.BiFunction;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.xmx.velthoric.builtin.cloth.ClothSoftBody;
import net.xmx.velthoric.physics.body.client.VxRenderState;
import net.xmx.velthoric.physics.body.client.body.renderer.VxSoftBodyRenderer;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ClothRenderer
extends VxSoftBodyRenderer<ClothSoftBody> {
    private static final class_2960 BLUE_WOOL_TEXTURE = class_2960.method_12829((String)"minecraft:block/blue_wool");

    @Override
    public void render(ClothSoftBody body, class_4587 poseStack, class_4597.class_4598 bufferSource, float partialTicks, int packedLight, VxRenderState renderState) {
        float[] renderVertexData = renderState.vertexData;
        int widthSegments = body.getSyncData(ClothSoftBody.DATA_WIDTH_SEGMENTS);
        int heightSegments = body.getSyncData(ClothSoftBody.DATA_HEIGHT_SEGMENTS);
        if (renderVertexData == null || renderVertexData.length < 12 || widthSegments <= 0 || heightSegments <= 0) {
            return;
        }
        int numVerticesX = widthSegments + 1;
        class_4588 buffer = bufferSource.getBuffer(class_1921.method_23583());
        class_1058 sprite = (class_1058)class_310.method_1551().method_1549(class_1059.field_5275).apply(BLUE_WOOL_TEXTURE);
        float minU = sprite.method_4594();
        float maxU = sprite.method_4577();
        float minV = sprite.method_4593();
        float maxV = sprite.method_4575();
        float deltaU = maxU - minU;
        float deltaV = maxV - minV;
        BiFunction<Integer, Integer, Vector3f> getVertexWorldPos = (x, y) -> {
            int index = (y * numVerticesX + x) * 3;
            if (index + 2 >= renderVertexData.length) {
                return new Vector3f();
            }
            return new Vector3f(renderVertexData[index], renderVertexData[index + 1], renderVertexData[index + 2]);
        };
        for (int y2 = 0; y2 < heightSegments; ++y2) {
            for (int x2 = 0; x2 < widthSegments; ++x2) {
                Vector3f edge2;
                Vector3f v1 = getVertexWorldPos.apply(x2, y2);
                Vector3f v2 = getVertexWorldPos.apply(x2 + 1, y2);
                Vector3f v3 = getVertexWorldPos.apply(x2 + 1, y2 + 1);
                Vector3f v4 = getVertexWorldPos.apply(x2, y2 + 1);
                float u1 = minU + deltaU * ((float)x2 / (float)widthSegments);
                float u2 = minU + deltaU * ((float)(x2 + 1) / (float)widthSegments);
                float v1Coord = minV + deltaV * ((float)y2 / (float)heightSegments);
                float v2Coord = minV + deltaV * ((float)(y2 + 1) / (float)heightSegments);
                Vector3f edge1 = new Vector3f((Vector3fc)v2).sub((Vector3fc)v1);
                Vector3f normal = edge1.cross((Vector3fc)(edge2 = new Vector3f((Vector3fc)v4).sub((Vector3fc)v1))).normalize();
                if (Float.isNaN(normal.x())) {
                    normal.set(0.0f, 1.0f, 0.0f);
                }
                this.addVertex(buffer, poseStack, v1, u1, v1Coord, normal, packedLight);
                this.addVertex(buffer, poseStack, v2, u2, v1Coord, normal, packedLight);
                this.addVertex(buffer, poseStack, v3, u2, v2Coord, normal, packedLight);
                this.addVertex(buffer, poseStack, v4, u1, v2Coord, normal, packedLight);
                Vector3f backNormal = new Vector3f((Vector3fc)normal).mul(-1.0f);
                this.addVertex(buffer, poseStack, v1, u1, v1Coord, backNormal, packedLight);
                this.addVertex(buffer, poseStack, v4, u1, v2Coord, backNormal, packedLight);
                this.addVertex(buffer, poseStack, v3, u2, v2Coord, backNormal, packedLight);
                this.addVertex(buffer, poseStack, v2, u2, v1Coord, backNormal, packedLight);
            }
        }
    }

    private void addVertex(class_4588 buffer, class_4587 poseStack, Vector3f pos, float u, float v, Vector3f normal, int packedLight) {
        buffer.method_56824(poseStack.method_23760(), pos.x(), pos.y(), pos.z()).method_1336(255, 255, 255, 255).method_22913(u, v).method_60803(packedLight).method_60831(poseStack.method_23760(), normal.x(), normal.y(), normal.z());
    }
}

