/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.builtin.marble;

import com.github.stephengold.joltjni.BodyCreationSettings;
import com.github.stephengold.joltjni.MassProperties;
import com.github.stephengold.joltjni.ShapeRefC;
import com.github.stephengold.joltjni.ShapeResult;
import com.github.stephengold.joltjni.SphereShapeSettings;
import com.github.stephengold.joltjni.enumerate.EMotionType;
import com.github.stephengold.joltjni.enumerate.EOverrideMassProperties;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.xmx.velthoric.network.VxByteBuf;
import net.xmx.velthoric.physics.body.registry.VxBodyType;
import net.xmx.velthoric.physics.body.sync.VxDataAccessor;
import net.xmx.velthoric.physics.body.sync.VxDataSerializers;
import net.xmx.velthoric.physics.body.sync.VxSynchronizedData;
import net.xmx.velthoric.physics.body.type.VxRigidBody;
import net.xmx.velthoric.physics.body.type.factory.VxRigidBodyFactory;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public class MarbleRigidBody
extends VxRigidBody {
    public static final VxDataAccessor<Float> DATA_RADIUS = VxDataAccessor.create(MarbleRigidBody.class, VxDataSerializers.FLOAT);
    private static final float DENSITY = 6700.0f;

    public MarbleRigidBody(VxBodyType<MarbleRigidBody> type, VxPhysicsWorld world, UUID id) {
        super((VxBodyType<? extends VxRigidBody>)type, world, id);
    }

    @Environment(value=EnvType.CLIENT)
    public MarbleRigidBody(VxBodyType<MarbleRigidBody> type, UUID id) {
        super((VxBodyType<? extends VxRigidBody>)type, id);
    }

    @Override
    protected void defineSyncData(VxSynchronizedData.Builder builder) {
        builder.define(DATA_RADIUS, Float.valueOf(0.15f));
    }

    public void setRadius(float radius) {
        this.setSyncData(DATA_RADIUS, Float.valueOf(radius));
    }

    public float getRadius() {
        return this.getSyncData(DATA_RADIUS).floatValue();
    }

    @Override
    public int createJoltBody(VxRigidBodyFactory factory) {
        float radius = this.getRadius();
        try (SphereShapeSettings shapeSettings = new SphereShapeSettings(radius);){
            int n;
            try (BodyCreationSettings bcs = new BodyCreationSettings();){
                bcs.setMotionType(EMotionType.Dynamic);
                bcs.setObjectLayer(1);
                bcs.setRestitution(0.3f);
                bcs.setFriction(0.2f);
                try (ShapeResult shapeResult = shapeSettings.create();
                     ShapeRefC shapeRef = shapeResult.get();
                     MassProperties massProperties = new MassProperties();){
                    float volume = (float)(4.1887902047863905 * (double)radius * (double)radius * (double)radius);
                    massProperties.setMassAndInertiaOfSolidBox(shapeRef.getLocalBounds().getExtent(), 6700.0f * volume);
                    bcs.setOverrideMassProperties(EOverrideMassProperties.MassAndInertiaProvided);
                    bcs.setMassPropertiesOverride(massProperties);
                }
                n = factory.create(shapeSettings, bcs);
            }
            return n;
        }
    }

    @Override
    public void writePersistenceData(VxByteBuf buf) {
        buf.method_52941(this.getRadius());
    }

    @Override
    public void readPersistenceData(VxByteBuf buf) {
        this.setRadius(buf.readFloat());
    }
}

