/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.command.argument;

import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.enumerate.EBodyType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.class_1937;
import net.minecraft.class_2096;
import net.minecraft.class_2168;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.xmx.velthoric.physics.body.type.VxBody;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.jetbrains.annotations.Nullable;

public class VxBodySelector {
    private final int limit;
    private final class_2096.class_2099 distance;
    @Nullable
    private final class_2960 type;
    private final boolean typeInverse;
    @Nullable
    private final EBodyType bodyType;
    private final BiConsumer<class_243, List<VxBody>> order;

    public VxBodySelector(int limit, class_2096.class_2099 distance, @Nullable class_2960 type, boolean typeInverse, @Nullable EBodyType bodyType, BiConsumer<class_243, List<VxBody>> order) {
        this.limit = limit;
        this.distance = distance;
        this.type = type;
        this.typeInverse = typeInverse;
        this.bodyType = bodyType;
        this.order = order;
    }

    private Predicate<VxBody> buildPredicate(class_2168 source) {
        class_243 sourcePos = source.method_9222();
        Predicate<VxBody> predicate = obj -> true;
        if (this.type != null) {
            predicate = predicate.and(obj -> obj.getType().getTypeId().equals((Object)this.type) != this.typeInverse);
        }
        if (this.bodyType != null) {
            predicate = predicate.and(obj -> {
                int index = obj.getDataStoreIndex();
                if (index != -1) {
                    return obj.getPhysicsWorld().getBodyManager().getDataStore().bodyType[index] == this.bodyType;
                }
                return false;
            });
        }
        if (!this.distance.method_9041()) {
            predicate = predicate.and(obj -> {
                RVec3 objPos = obj.getTransform().getTranslation();
                return this.distance.method_9045(sourcePos.method_1028((double)objPos.x(), (double)objPos.y(), (double)objPos.z()));
            });
        }
        return predicate;
    }

    public List<VxBody> select(class_2168 source) {
        VxPhysicsWorld world = VxPhysicsWorld.get((class_5321<class_1937>)source.method_9225().method_27983());
        if (world == null) {
            return Collections.emptyList();
        }
        Predicate<VxBody> predicate = this.buildPredicate(source);
        ArrayList<VxBody> allBodies = new ArrayList<VxBody>(world.getBodyManager().getAllBodies());
        ArrayList<VxBody> filteredBodies = new ArrayList<VxBody>();
        for (VxBody body : allBodies) {
            if (!predicate.test(body)) continue;
            filteredBodies.add(body);
        }
        this.order.accept(source.method_9222(), filteredBodies);
        if (filteredBodies.size() <= this.limit) {
            return filteredBodies;
        }
        return filteredBodies.subList(0, this.limit);
    }
}

