/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.debug;

import com.github.stephengold.joltjni.Jolt;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.xmx.velthoric.event.api.VxF3ScreenAdditionEvent;
import net.xmx.velthoric.physics.body.client.VxClientBodyDataStore;
import net.xmx.velthoric.physics.body.client.VxClientBodyManager;
import net.xmx.velthoric.physics.body.type.VxBody;
import net.xmx.velthoric.physics.body.type.VxRigidBody;
import net.xmx.velthoric.physics.body.type.VxSoftBody;

@Environment(value=EnvType.CLIENT)
public class VxF3ScreenAddition {
    public static void registerEvents() {
        VxF3ScreenAdditionEvent.AddDebugInfo.EVENT.register(VxF3ScreenAddition::onDebugEvent);
    }

    public static void onDebugEvent(VxF3ScreenAdditionEvent.AddDebugInfo event) {
        List<String> infoList = event.getInfoList();
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return;
        }
        infoList.add("");
        infoList.add("Jolt JNI v" + Jolt.versionString());
        VxF3ScreenAddition.addClientInfo(infoList);
    }

    private static void addClientInfo(List<String> left) {
        VxClientBodyManager clientManager = VxClientBodyManager.getInstance();
        VxClientBodyDataStore store = clientManager.getStore();
        long clientRigidCount = 0L;
        long clientSoftCount = 0L;
        for (UUID id : store.getAllPhysicsIds()) {
            VxBody body = clientManager.getBody(id);
            if (body == null) continue;
            if (body instanceof VxRigidBody) {
                ++clientRigidCount;
                continue;
            }
            if (!(body instanceof VxSoftBody)) continue;
            ++clientSoftCount;
        }
        int bodyCount = store.getBodyCount();
        int capacity = store.getCapacity();
        int freeIndices = store.getFreeIndicesCount();
        long memoryBytes = store.getMemoryUsageBytes();
        String memoryString = memoryBytes > 0x100000L ? String.format("%.2f MB", (double)memoryBytes / 1048576.0) : String.format("%d KB", memoryBytes / 1024L);
        left.add(String.format("Bodies: %d (RB: %d, SB: %d)", bodyCount, clientRigidCount, clientSoftCount));
        left.add(String.format("Store: C: %d/%d | F: %d | M: %s", bodyCount, capacity, freeIndices, memoryString));
    }
}

