/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.item.boxthrower;

import com.github.stephengold.joltjni.BodyInterface;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Vec3;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.xmx.velthoric.builtin.VxRegisteredBodies;
import net.xmx.velthoric.builtin.box.BoxColor;
import net.xmx.velthoric.builtin.box.BoxRigidBody;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.body.manager.VxBodyManager;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public class VxBoxThrowerManager {
    private static final VxBoxThrowerManager INSTANCE = new VxBoxThrowerManager();
    private final Map<UUID, Boolean> shootingPlayers = new ConcurrentHashMap<UUID, Boolean>();
    private static final int BOXES_PER_TICK = 5;
    private static final float SHOOT_SPEED = 40.0f;
    private static final float SPAWN_OFFSET = 1.5f;
    private static final float MIN_BOX_SIZE = 0.4f;
    private static final float MAX_BOX_SIZE = 1.2f;

    private VxBoxThrowerManager() {
    }

    public static VxBoxThrowerManager getInstance() {
        return INSTANCE;
    }

    public void startShooting(class_3222 player) {
        this.shootingPlayers.put(player.method_5667(), true);
    }

    public void stopShooting(class_3222 player) {
        this.shootingPlayers.remove(player.method_5667());
    }

    public boolean isShooting(class_3222 player) {
        return this.shootingPlayers.getOrDefault(player.method_5667(), false);
    }

    public void serverTick(class_3222 player) {
        VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((class_5321<class_1937>)player.method_37908().method_27983());
        if (physicsWorld == null || !physicsWorld.isRunning()) {
            this.stopShooting(player);
            return;
        }
        physicsWorld.execute(() -> {
            for (int i = 0; i < 5; ++i) {
                this.spawnAndLaunchSingleBox(player, physicsWorld);
            }
        });
    }

    private void spawnAndLaunchSingleBox(class_3222 player, VxPhysicsWorld physicsWorld) {
        class_243 eyePos = player.method_33571();
        class_243 lookVec = player.method_5720();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        class_243 spawnPosMc = eyePos.method_1019(lookVec.method_1021(1.5));
        VxTransform transform = new VxTransform(new RVec3((float)spawnPosMc.field_1352, (float)spawnPosMc.field_1351, (float)spawnPosMc.field_1350), Quat.sIdentity());
        float randomWidth = random.nextFloat(0.4f, 1.2f);
        float randomHeight = random.nextFloat(0.4f, 1.2f);
        float randomDepth = random.nextFloat(0.4f, 1.2f);
        Vec3 halfExtents = new Vec3(randomWidth / 2.0f, randomHeight / 2.0f, randomDepth / 2.0f);
        Vec3 launchVelocity = new Vec3((float)lookVec.field_1352, (float)lookVec.field_1351, (float)lookVec.field_1350);
        launchVelocity.scaleInPlace(40.0f);
        VxBodyManager manager = physicsWorld.getBodyManager();
        BoxRigidBody spawnedBody = manager.createRigidBody(VxRegisteredBodies.BOX, transform, box -> {
            box.setHalfExtents(halfExtents);
            box.setColor(BoxColor.getRandom());
        });
        if (spawnedBody != null) {
            int bodyId = spawnedBody.getBodyId();
            BodyInterface bodyInterface = physicsWorld.getPhysicsSystem().getBodyInterface();
            bodyInterface.activateBody(bodyId);
            bodyInterface.setLinearVelocity(bodyId, launchVelocity);
        }
    }
}

