/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.mixin.impl.mounting.entity;

import com.github.stephengold.joltjni.Quat;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.xmx.velthoric.math.VxConversions;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.body.type.VxBody;
import net.xmx.velthoric.physics.mounting.entity.VxMountingEntity;
import net.xmx.velthoric.physics.mounting.util.VxMountingRenderUtils;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.joml.Quaterniond;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1297.class})
public abstract class MixinEntity {
    @Shadow
    private class_1937 field_6002;
    @Unique
    private final VxTransform velthoric_interpolatedTransform = new VxTransform();

    @Shadow
    public abstract float method_5751();

    @Shadow
    public abstract class_1297 method_5854();

    @Inject(method={"getEyePosition(F)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private void velthoric_getEyePositionOnPhysicsBody(float partialTicks, CallbackInfoReturnable<class_243> cir) {
        class_1297 class_12972;
        if (!this.field_6002.method_8608() || !((class_12972 = this.method_5854()) instanceof VxMountingEntity)) {
            return;
        }
        VxMountingEntity proxy = (VxMountingEntity)class_12972;
        VxMountingRenderUtils.INSTANCE.getInterpolatedTransform(proxy, partialTicks, this.velthoric_interpolatedTransform).ifPresent(transform -> {
            Quat joltRotation = transform.getRotation();
            Quaterniond physRotation = new Quaterniond((double)joltRotation.getX(), (double)joltRotation.getY(), (double)joltRotation.getZ(), (double)joltRotation.getW());
            Vector3f rideOffset = new Vector3f((Vector3fc)proxy.getMountPositionOffset());
            physRotation.transform(rideOffset);
            Vector3d playerBasePos = VxConversions.toJoml(transform.getTranslation(), new Vector3d()).add((double)rideOffset.x, (double)rideOffset.y, (double)rideOffset.z);
            Vector3d eyeOffset = new Vector3d(0.0, (double)this.method_5751(), 0.0);
            physRotation.transform(eyeOffset);
            Vector3d finalEyePos = playerBasePos.add((Vector3dc)eyeOffset);
            cir.setReturnValue((Object)VxConversions.toMinecraft(finalEyePos));
        });
    }

    @Inject(method={"calculateViewVector(FF)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="RETURN")}, cancellable=true)
    private void velthoric_transformViewVector(float xRot, float yRot, CallbackInfoReturnable<class_243> cir) {
        class_1297 self = (class_1297)this;
        class_1297 class_12972 = self.method_5854();
        if (!(class_12972 instanceof VxMountingEntity)) {
            return;
        }
        VxMountingEntity proxy = (VxMountingEntity)class_12972;
        proxy.getPhysicsId().ifPresent(id -> {
            Quaterniond vehicleRotation;
            class_243 localViewVector = (class_243)cir.getReturnValue();
            Vector3d transformedVector = VxConversions.toJoml(localViewVector, new Vector3d());
            if (this.field_6002.method_8608()) {
                vehicleRotation = this.velthoric_getInterpolatedRotationClient(proxy).orElse(null);
                if (vehicleRotation == null) {
                    return;
                }
            } else {
                VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((class_5321<class_1937>)this.field_6002.method_27983());
                if (physicsWorld == null) {
                    return;
                }
                VxBody body = physicsWorld.getBodyManager().getVxBody((UUID)id);
                if (body == null) {
                    return;
                }
                Quat rot = body.getTransform().getRotation();
                vehicleRotation = new Quaterniond((double)rot.getX(), (double)rot.getY(), (double)rot.getZ(), (double)rot.getW());
            }
            vehicleRotation.transform(transformedVector);
            cir.setReturnValue((Object)VxConversions.toMinecraft(transformedVector));
        });
    }

    @Unique
    @Environment(value=EnvType.CLIENT)
    private Optional<Quaterniond> velthoric_getInterpolatedRotationClient(VxMountingEntity proxy) {
        float partialTicks = class_310.method_1551().method_60646().method_60637(true);
        return VxMountingRenderUtils.INSTANCE.getInterpolatedRotation(proxy, partialTicks).map(q -> new Quaterniond((double)q.getX(), (double)q.getY(), (double)q.getZ(), (double)q.getW()));
    }
}

