/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.mixin.impl.mounting.render;

import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.xmx.velthoric.math.VxConversions;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.mounting.entity.VxMountingEntity;
import net.xmx.velthoric.physics.mounting.util.VxMountingRenderUtils;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_4184.class})
public abstract class MixinCamera {
    @Shadow
    @Final
    private Quaternionf field_21518;
    @Shadow
    @Final
    private Vector3f field_18714;
    @Shadow
    @Final
    private Vector3f field_18715;
    @Shadow
    @Final
    private Vector3f field_18716;
    @Shadow
    private boolean field_18709;
    @Shadow
    private class_1922 field_18710;
    @Shadow
    private boolean field_18719;
    @Shadow
    private class_1297 field_18711;
    @Shadow
    private float field_18721;
    @Shadow
    private float field_18722;
    @Shadow
    private float field_18718;
    @Shadow
    private float field_18717;
    @Shadow
    private class_243 field_18712;
    @Unique
    private static final Vector3f FORWARDS_CONST = new Vector3f(0.0f, 0.0f, -1.0f);
    @Unique
    private static final Vector3f UP_CONST = new Vector3f(0.0f, 1.0f, 0.0f);
    @Unique
    private static final Vector3f LEFT_CONST = new Vector3f(-1.0f, 0.0f, 0.0f);
    @Unique
    private final VxTransform velthoric_interpolatedTransform = new VxTransform();

    @Shadow
    protected abstract void method_19327(double var1, double var3, double var5);

    @Shadow
    protected abstract void method_19324(float var1, float var2, float var3);

    @Inject(method={"setup"}, at={@At(value="HEAD")}, cancellable=true)
    private void velthoric_followPhysicsBody(class_1922 level, class_1297 focusedEntity, boolean detached, boolean thirdPersonReverse, float partialTick, CallbackInfo ci) {
        VxMountingEntity proxy;
        Optional<VxTransform> transformOpt;
        class_1297 class_12972 = focusedEntity.method_5854();
        if (class_12972 instanceof VxMountingEntity && (transformOpt = VxMountingRenderUtils.INSTANCE.getInterpolatedTransform(proxy = (VxMountingEntity)class_12972, partialTick, this.velthoric_interpolatedTransform)).isPresent()) {
            VxTransform transform = transformOpt.get();
            Quaternionf physRotation = transform.getRotation(new Quaternionf());
            Vector3f rideOffset = new Vector3f((Vector3fc)proxy.getMountPositionOffset());
            physRotation.transform(rideOffset);
            Vector3d playerBasePos = VxConversions.toJoml(transform.getTranslation(), new Vector3d()).add((double)rideOffset.x, (double)rideOffset.y, (double)rideOffset.z);
            double eyeY = class_3532.method_16439((float)partialTick, (float)this.field_18722, (float)this.field_18721);
            Vector3f eyeOffset = new Vector3f(0.0f, (float)eyeY, 0.0f);
            physRotation.transform(eyeOffset);
            Vector3d playerEyePos = playerBasePos.add((double)eyeOffset.x(), (double)eyeOffset.y(), (double)eyeOffset.z());
            this.field_18709 = true;
            this.field_18710 = level;
            this.field_18711 = focusedEntity;
            this.field_18719 = detached;
            this.method_19327(playerEyePos.x, playerEyePos.y, playerEyePos.z);
            float yaw = focusedEntity.method_5705(partialTick);
            float pitch = focusedEntity.method_5695(partialTick);
            if (detached) {
                if (thirdPersonReverse) {
                    yaw += 180.0f;
                    pitch = -pitch;
                }
                this.velthoric_setRotationWithPhysicsTransform(yaw, pitch, physRotation);
                float scale = 1.0f;
                if (focusedEntity instanceof class_1309) {
                    scale = ((class_1309)focusedEntity).method_55693();
                }
                float zoomDistance = this.velthoric_getMaxZoom(4.0f * scale);
                this.method_19324(-zoomDistance, 0.0f, 0.0f);
            } else {
                this.velthoric_setRotationWithPhysicsTransform(yaw, pitch, physRotation);
            }
            ci.cancel();
        }
    }

    @Unique
    private void velthoric_setRotationWithPhysicsTransform(float yaw, float pitch, Quaternionf physRotation) {
        this.field_18717 = pitch;
        this.field_18718 = yaw;
        Quaternionf localRotation = new Quaternionf().rotationYXZ((float)Math.PI - yaw * ((float)Math.PI / 180), -pitch * ((float)Math.PI / 180), 0.0f);
        Quaternionf finalRotation = new Quaternionf((Quaternionfc)physRotation).mul((Quaternionfc)localRotation);
        this.field_21518.set((Quaternionfc)finalRotation);
        FORWARDS_CONST.rotate((Quaternionfc)this.field_21518, this.field_18714);
        UP_CONST.rotate((Quaternionfc)this.field_21518, this.field_18715);
        LEFT_CONST.rotate((Quaternionfc)this.field_21518, this.field_18716);
    }

    @Unique
    private float velthoric_getMaxZoom(float maxZoom) {
        for (int i = 0; i < 8; ++i) {
            float k;
            class_243 vec32;
            float g = (i & 1) * 2 - 1;
            float h = (i >> 1 & 1) * 2 - 1;
            float j = (i >> 2 & 1) * 2 - 1;
            class_243 vec3 = this.field_18712.method_1031((double)(g * 0.1f), (double)(h * 0.1f), (double)(j * 0.1f));
            class_3965 hitResult = this.field_18710.method_17742(new class_3959(vec3, vec32 = vec3.method_1019(new class_243(this.field_18714).method_1021((double)(-maxZoom))), class_3959.class_3960.field_23142, class_3959.class_242.field_1348, this.field_18711));
            if (hitResult.method_17783() == class_239.class_240.field_1333 || !((k = (float)hitResult.method_17784().method_1025(this.field_18712)) < class_3532.method_27285((float)maxZoom))) continue;
            maxZoom = class_3532.method_15355((float)k);
        }
        return maxZoom;
    }
}

