/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.natives;

import com.github.luben.zstd.util.Native;
import java.nio.file.Path;
import net.xmx.velthoric.natives.VxNativeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VxNativeZstd {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Velthoric Zstd-JNI");
    private static volatile boolean isInitialized = false;

    public static void initialize(Path extractionPath) {
        if (isInitialized) {
            return;
        }
        LOGGER.debug("Performing Zstd-JNI initialization...");
        Native.assumeLoaded();
        VxNativeManager.loadLibrary(extractionPath, "zstd-jni");
        isInitialized = true;
        LOGGER.debug("Zstd-JNI native library loaded successfully via Velthoric loader.");
    }

    public static boolean isInitialized() {
        return isInitialized;
    }
}

