/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.utils.GameInstance;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import net.xmx.velthoric.item.boxthrower.packet.VxBoxThrowerActionPacket;
import net.xmx.velthoric.item.chaincreator.packet.VxChainCreatorActionPacket;
import net.xmx.velthoric.item.magnetizer.packet.VxMagnetizerActionPacket;
import net.xmx.velthoric.item.physicsgun.packet.VxPhysicsGunActionPacket;
import net.xmx.velthoric.item.physicsgun.packet.VxPhysicsGunSyncPacket;
import net.xmx.velthoric.physics.body.packet.batch.S2CRemoveBodyBatchPacket;
import net.xmx.velthoric.physics.body.packet.batch.S2CSpawnBodyBatchPacket;
import net.xmx.velthoric.physics.body.packet.batch.S2CSynchronizedDataBatchPacket;
import net.xmx.velthoric.physics.body.packet.batch.S2CUpdateBodyStateBatchPacket;
import net.xmx.velthoric.physics.body.packet.batch.S2CUpdateVerticesBatchPacket;
import net.xmx.velthoric.physics.mounting.input.C2SMountInputPacket;
import net.xmx.velthoric.physics.mounting.request.C2SRequestMountPacket;
import net.xmx.velthoric.physics.vehicle.sync.S2CVehicleStatePacket;

public class VxPacketHandler {
    private static final String CHANNEL_NAMESPACE = "velthoric";
    private static final Map<Class<?>, PacketInfo<?>> PACKETS = new HashMap();

    private static <T> void registerPacket(Class<T> type, String name, BiConsumer<T, class_2540> encoder, Function<class_2540, T> decoder, BiConsumer<T, Supplier<NetworkManager.PacketContext>> handler, NetworkManager.Side side) {
        class_2960 id = class_2960.method_43902((String)CHANNEL_NAMESPACE, (String)name);
        class_8710.class_9154 payloadType = new class_8710.class_9154(id);
        PACKETS.put(type, new PacketInfo(payloadType));
        class_9139 codec = class_9139.method_56437((buf, wrapper) -> encoder.accept(wrapper.message(), (class_2540)buf), buf -> new PacketWrapper(decoder.apply((class_2540)buf), payloadType));
        NetworkManager.NetworkReceiver receiver = (wrapper, context) -> handler.accept(wrapper.message(), () -> context);
        if (side == NetworkManager.Side.C2S) {
            NetworkManager.registerReceiver((NetworkManager.Side)side, (class_8710.class_9154)payloadType, (class_9139)codec, (NetworkManager.NetworkReceiver)receiver);
        } else if (Platform.getEnv() == EnvType.CLIENT) {
            NetworkManager.registerReceiver((NetworkManager.Side)side, (class_8710.class_9154)payloadType, (class_9139)codec, (NetworkManager.NetworkReceiver)receiver);
        } else {
            NetworkManager.registerS2CPayloadType((class_8710.class_9154)payloadType, (class_9139)codec);
        }
    }

    public static void register() {
        VxPacketHandler.registerPacket(VxChainCreatorActionPacket.class, "chain_creator_action", VxChainCreatorActionPacket::encode, VxChainCreatorActionPacket::decode, VxChainCreatorActionPacket::handle, NetworkManager.Side.C2S);
        VxPacketHandler.registerPacket(C2SRequestMountPacket.class, "request_mount", C2SRequestMountPacket::encode, C2SRequestMountPacket::decode, C2SRequestMountPacket::handle, NetworkManager.Side.C2S);
        VxPacketHandler.registerPacket(C2SMountInputPacket.class, "mount_input", C2SMountInputPacket::encode, C2SMountInputPacket::decode, C2SMountInputPacket::handle, NetworkManager.Side.C2S);
        VxPacketHandler.registerPacket(VxMagnetizerActionPacket.class, "magnetizer_action", VxMagnetizerActionPacket::encode, VxMagnetizerActionPacket::decode, VxMagnetizerActionPacket::handle, NetworkManager.Side.C2S);
        VxPacketHandler.registerPacket(VxPhysicsGunActionPacket.class, "physics_gun_action", VxPhysicsGunActionPacket::encode, VxPhysicsGunActionPacket::decode, VxPhysicsGunActionPacket::handle, NetworkManager.Side.C2S);
        VxPacketHandler.registerPacket(VxBoxThrowerActionPacket.class, "box_thrower_action", VxBoxThrowerActionPacket::encode, VxBoxThrowerActionPacket::decode, VxBoxThrowerActionPacket::handle, NetworkManager.Side.C2S);
        VxPacketHandler.registerPacket(S2CSynchronizedDataBatchPacket.class, "sync_data_batch", S2CSynchronizedDataBatchPacket::encode, S2CSynchronizedDataBatchPacket::decode, S2CSynchronizedDataBatchPacket::handle, NetworkManager.Side.S2C);
        VxPacketHandler.registerPacket(S2CVehicleStatePacket.class, "vehicle_state", S2CVehicleStatePacket::encode, S2CVehicleStatePacket::decode, S2CVehicleStatePacket::handle, NetworkManager.Side.S2C);
        VxPacketHandler.registerPacket(S2CSpawnBodyBatchPacket.class, "spawn_body_batch", S2CSpawnBodyBatchPacket::encode, S2CSpawnBodyBatchPacket::decode, S2CSpawnBodyBatchPacket::handle, NetworkManager.Side.S2C);
        VxPacketHandler.registerPacket(S2CRemoveBodyBatchPacket.class, "remove_body_batch", S2CRemoveBodyBatchPacket::encode, S2CRemoveBodyBatchPacket::decode, S2CRemoveBodyBatchPacket::handle, NetworkManager.Side.S2C);
        VxPacketHandler.registerPacket(S2CUpdateBodyStateBatchPacket.class, "update_body_state_batch", S2CUpdateBodyStateBatchPacket::encode, S2CUpdateBodyStateBatchPacket::decode, S2CUpdateBodyStateBatchPacket::handle, NetworkManager.Side.S2C);
        VxPacketHandler.registerPacket(S2CUpdateVerticesBatchPacket.class, "update_vertices_batch", S2CUpdateVerticesBatchPacket::encode, S2CUpdateVerticesBatchPacket::decode, S2CUpdateVerticesBatchPacket::handle, NetworkManager.Side.S2C);
        VxPacketHandler.registerPacket(VxPhysicsGunSyncPacket.class, "physics_gun_sync", VxPhysicsGunSyncPacket::encode, VxPhysicsGunSyncPacket::decode, VxPhysicsGunSyncPacket::handle, NetworkManager.Side.S2C);
    }

    private static <MSG> PacketInfo<MSG> getPacketInfo(MSG message) {
        PacketInfo<?> info = PACKETS.get(message.getClass());
        return Objects.requireNonNull(info, "Unregistered packet type: " + message.getClass().getName());
    }

    public static <MSG> void sendToServer(MSG message) {
        PacketInfo<MSG> info = VxPacketHandler.getPacketInfo(message);
        NetworkManager.sendToServer(new PacketWrapper<MSG>(message, info.type()));
    }

    public static <MSG> void sendToPlayer(MSG message, class_3222 player) {
        PacketInfo<MSG> info = VxPacketHandler.getPacketInfo(message);
        NetworkManager.sendToPlayer((class_3222)player, new PacketWrapper<MSG>(message, info.type()));
    }

    public static <MSG> void sendToDimension(MSG message, class_5321<class_1937> dimensionKey) {
        class_3218 level;
        if (GameInstance.getServer() != null && (level = GameInstance.getServer().method_3847(dimensionKey)) != null) {
            PacketInfo<MSG> info = VxPacketHandler.getPacketInfo(message);
            NetworkManager.sendToPlayers((Iterable)level.method_18456(), new PacketWrapper<MSG>(message, info.type()));
        }
    }

    public static <MSG> void sendToAll(MSG message) {
        if (GameInstance.getServer() != null) {
            PacketInfo<MSG> info = VxPacketHandler.getPacketInfo(message);
            NetworkManager.sendToPlayers((Iterable)GameInstance.getServer().method_3760().method_14571(), new PacketWrapper<MSG>(message, info.type()));
        }
    }

    private record PacketInfo<T>(class_8710.class_9154<PacketWrapper<T>> type) {
    }

    private static final class PacketWrapper<T>
    extends Record
    implements class_8710 {
        private final T message;
        private final class_8710.class_9154<PacketWrapper<T>> type;

        private PacketWrapper(T message, class_8710.class_9154<PacketWrapper<T>> type) {
            this.message = message;
            this.type = type;
        }

        public class_8710.class_9154<PacketWrapper<T>> method_56479() {
            return this.type;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{PacketWrapper.class, "message;type", "message", "type"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PacketWrapper.class, "message;type", "message", "type"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PacketWrapper.class, "message;type", "message", "type"}, this, o);
        }

        public T message() {
            return this.message;
        }
    }
}

