/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.body.client.renderer;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.xmx.velthoric.math.VxOBB;
import net.xmx.velthoric.physics.body.client.VxClientBodyManager;
import net.xmx.velthoric.physics.body.client.VxRenderState;
import net.xmx.velthoric.physics.body.type.VxBody;
import net.xmx.velthoric.physics.mounting.manager.VxClientMountingManager;
import net.xmx.velthoric.physics.mounting.seat.VxSeat;

public class VxDebugRenderer {
    private final VxRenderState renderState = new VxRenderState();
    private final RVec3 interpolatedPosition = new RVec3();
    private final Quat interpolatedRotation = new Quat();

    public void render(class_4587 poseStack, class_4597 bufferSource, VxClientBodyManager manager, float partialTicks) {
        this.renderSeatHitboxes(poseStack, bufferSource, manager, partialTicks);
    }

    private void renderSeatHitboxes(class_4587 poseStack, class_4597 bufferSource, VxClientBodyManager manager, float partialTicks) {
        class_4588 vertexConsumer = bufferSource.getBuffer(class_1921.method_23594());
        VxClientMountingManager ridingManager = VxClientMountingManager.INSTANCE;
        for (VxBody body : manager.getAllBodies()) {
            if (!body.isInitialized()) continue;
            body.calculateRenderState(partialTicks, this.renderState, this.interpolatedPosition, this.interpolatedRotation);
            for (VxSeat seat : ridingManager.getSeats(body.getPhysicsId())) {
                VxOBB obb = seat.getGlobalOBB(this.renderState.transform);
                if (seat.isDriverSeat()) {
                    this.drawOBB(vertexConsumer, poseStack, obb, 1.0f, 0.0f, 0.0f, 1.0f);
                    continue;
                }
                this.drawOBB(vertexConsumer, poseStack, obb, 0.2f, 0.6f, 1.0f, 1.0f);
            }
        }
    }

    private void drawOBB(class_4588 consumer, class_4587 poseStack, VxOBB obb, float r, float g, float b, float a) {
        class_243[] corners = obb.getCorners();
        VxDebugRenderer.drawLine(consumer, poseStack, corners[0], corners[1], r, g, b, a);
        VxDebugRenderer.drawLine(consumer, poseStack, corners[1], corners[5], r, g, b, a);
        VxDebugRenderer.drawLine(consumer, poseStack, corners[5], corners[4], r, g, b, a);
        VxDebugRenderer.drawLine(consumer, poseStack, corners[4], corners[0], r, g, b, a);
        VxDebugRenderer.drawLine(consumer, poseStack, corners[3], corners[2], r, g, b, a);
        VxDebugRenderer.drawLine(consumer, poseStack, corners[2], corners[6], r, g, b, a);
        VxDebugRenderer.drawLine(consumer, poseStack, corners[6], corners[7], r, g, b, a);
        VxDebugRenderer.drawLine(consumer, poseStack, corners[7], corners[3], r, g, b, a);
        VxDebugRenderer.drawLine(consumer, poseStack, corners[0], corners[3], r, g, b, a);
        VxDebugRenderer.drawLine(consumer, poseStack, corners[1], corners[2], r, g, b, a);
        VxDebugRenderer.drawLine(consumer, poseStack, corners[4], corners[7], r, g, b, a);
        VxDebugRenderer.drawLine(consumer, poseStack, corners[5], corners[6], r, g, b, a);
    }

    private static void drawLine(class_4588 consumer, class_4587 poseStack, class_243 p1, class_243 p2, float r, float g, float b, float a) {
        class_4587.class_4665 last = poseStack.method_23760();
        consumer.method_22918(last.method_23761(), (float)p1.field_1352, (float)p1.field_1351, (float)p1.field_1350).method_22915(r, g, b, a).method_60831(last, 0.0f, 1.0f, 0.0f);
        consumer.method_22918(last.method_23761(), (float)p2.field_1352, (float)p2.field_1351, (float)p2.field_1350).method_22915(r, g, b, a).method_60831(last, 0.0f, 1.0f, 0.0f);
    }
}

