/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.body.packet.batch;

import com.github.stephengold.joltjni.RVec3;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.function.Supplier;
import net.minecraft.class_2540;
import net.xmx.velthoric.network.VxPacketUtils;
import net.xmx.velthoric.physics.body.client.VxClientBodyDataStore;
import net.xmx.velthoric.physics.body.client.VxClientBodyManager;

public class S2CUpdateBodyStateBatchPacket {
    private final int count;
    private final int[] networkIds;
    private final long[] timestamps;
    private final double[] posX;
    private final double[] posY;
    private final double[] posZ;
    private final float[] rotX;
    private final float[] rotY;
    private final float[] rotZ;
    private final float[] rotW;
    private final float[] velX;
    private final float[] velY;
    private final float[] velZ;
    private final boolean[] isActive;

    public S2CUpdateBodyStateBatchPacket(int count, int[] networkIds, long[] timestamps, double[] posX, double[] posY, double[] posZ, float[] rotX, float[] rotY, float[] rotZ, float[] rotW, float[] velX, float[] velY, float[] velZ, boolean[] isActive) {
        this.count = count;
        this.networkIds = networkIds;
        this.timestamps = timestamps;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.rotX = rotX;
        this.rotY = rotY;
        this.rotZ = rotZ;
        this.rotW = rotW;
        this.velX = velX;
        this.velY = velY;
        this.velZ = velZ;
        this.isActive = isActive;
    }

    public static void encode(S2CUpdateBodyStateBatchPacket msg, class_2540 buf) {
        class_2540 tempBuf = new class_2540(Unpooled.buffer());
        try {
            tempBuf.method_10804(msg.count);
            for (int i = 0; i < msg.count; ++i) {
                tempBuf.method_10804(msg.networkIds[i]);
                tempBuf.method_52974(msg.timestamps[i]);
                tempBuf.method_52940(msg.posX[i]);
                tempBuf.method_52940(msg.posY[i]);
                tempBuf.method_52940(msg.posZ[i]);
                tempBuf.method_52941(msg.rotX[i]);
                tempBuf.method_52941(msg.rotY[i]);
                tempBuf.method_52941(msg.rotZ[i]);
                tempBuf.method_52941(msg.rotW[i]);
                tempBuf.method_52964(msg.isActive[i]);
                if (!msg.isActive[i]) continue;
                tempBuf.method_52941(msg.velX[i]);
                tempBuf.method_52941(msg.velY[i]);
                tempBuf.method_52941(msg.velZ[i]);
            }
            byte[] uncompressedData = new byte[tempBuf.readableBytes()];
            tempBuf.method_52979(uncompressedData);
            byte[] compressedData = VxPacketUtils.compress(uncompressedData);
            buf.method_10804(uncompressedData.length);
            buf.method_10813(compressedData);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to compress body state batch packet", e);
        }
        finally {
            tempBuf.release();
        }
    }

    public static S2CUpdateBodyStateBatchPacket decode(class_2540 buf) {
        try {
            int uncompressedSize = buf.method_10816();
            byte[] compressedData = buf.method_10795();
            byte[] decompressedData = VxPacketUtils.decompress(compressedData, uncompressedSize);
            class_2540 decompressedBuf = new class_2540(Unpooled.wrappedBuffer((byte[])decompressedData));
            int count = decompressedBuf.method_10816();
            int[] networkIds = new int[count];
            long[] timestamps = new long[count];
            double[] posX = new double[count];
            double[] posY = new double[count];
            double[] posZ = new double[count];
            float[] rotX = new float[count];
            float[] rotY = new float[count];
            float[] rotZ = new float[count];
            float[] rotW = new float[count];
            float[] velX = new float[count];
            float[] velY = new float[count];
            float[] velZ = new float[count];
            boolean[] isActive = new boolean[count];
            for (int i = 0; i < count; ++i) {
                networkIds[i] = decompressedBuf.method_10816();
                timestamps[i] = decompressedBuf.readLong();
                posX[i] = decompressedBuf.readDouble();
                posY[i] = decompressedBuf.readDouble();
                posZ[i] = decompressedBuf.readDouble();
                rotX[i] = decompressedBuf.readFloat();
                rotY[i] = decompressedBuf.readFloat();
                rotZ[i] = decompressedBuf.readFloat();
                rotW[i] = decompressedBuf.readFloat();
                isActive[i] = decompressedBuf.readBoolean();
                if (!isActive[i]) continue;
                velX[i] = decompressedBuf.readFloat();
                velY[i] = decompressedBuf.readFloat();
                velZ[i] = decompressedBuf.readFloat();
            }
            return new S2CUpdateBodyStateBatchPacket(count, networkIds, timestamps, posX, posY, posZ, rotX, rotY, rotZ, rotW, velX, velY, velZ, isActive);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to decompress body state batch packet", e);
        }
    }

    public static void handle(S2CUpdateBodyStateBatchPacket msg, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            VxClientBodyManager manager = VxClientBodyManager.getInstance();
            VxClientBodyDataStore store = manager.getStore();
            long clientReceiptTime = manager.getClock().getGameTimeNanos();
            for (int i = 0; i < msg.count; ++i) {
                Integer index = store.getIndexForNetworkId(msg.networkIds[i]);
                if (index == null) continue;
                manager.addClockSyncSample(msg.timestamps[i] - clientReceiptTime);
                store.state0_timestamp[index.intValue()] = store.state1_timestamp[index];
                store.state0_posX[index.intValue()] = store.state1_posX[index];
                store.state0_posY[index.intValue()] = store.state1_posY[index];
                store.state0_posZ[index.intValue()] = store.state1_posZ[index];
                store.state0_rotX[index.intValue()] = store.state1_rotX[index];
                store.state0_rotY[index.intValue()] = store.state1_rotY[index];
                store.state0_rotZ[index.intValue()] = store.state1_rotZ[index];
                store.state0_rotW[index.intValue()] = store.state1_rotW[index];
                store.state0_velX[index.intValue()] = store.state1_velX[index];
                store.state0_velY[index.intValue()] = store.state1_velY[index];
                store.state0_velZ[index.intValue()] = store.state1_velZ[index];
                store.state0_isActive[index.intValue()] = store.state1_isActive[index];
                store.state0_vertexData[index.intValue()] = store.state1_vertexData[index];
                store.state1_timestamp[index.intValue()] = msg.timestamps[i];
                store.state1_posX[index.intValue()] = (float)msg.posX[i];
                store.state1_posY[index.intValue()] = (float)msg.posY[i];
                store.state1_posZ[index.intValue()] = (float)msg.posZ[i];
                store.state1_rotX[index.intValue()] = msg.rotX[i];
                store.state1_rotY[index.intValue()] = msg.rotY[i];
                store.state1_rotZ[index.intValue()] = msg.rotZ[i];
                store.state1_rotW[index.intValue()] = msg.rotW[i];
                store.state1_isActive[index.intValue()] = msg.isActive[i];
                if (store.state1_isActive[index]) {
                    store.state1_velX[index.intValue()] = msg.velX[i];
                    store.state1_velY[index.intValue()] = msg.velY[i];
                    store.state1_velZ[index.intValue()] = msg.velZ[i];
                } else {
                    store.state1_velX[index.intValue()] = 0.0f;
                    store.state1_velY[index.intValue()] = 0.0f;
                    store.state1_velZ[index.intValue()] = 0.0f;
                }
                if (store.lastKnownPosition[index] == null) {
                    store.lastKnownPosition[index.intValue()] = new RVec3();
                }
                store.lastKnownPosition[index].set((float)msg.posX[i], (float)msg.posY[i], (float)msg.posZ[i]);
            }
        });
    }
}

