/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.body.persistence;

import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EMotionType;
import java.util.UUID;
import net.minecraft.class_2960;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.network.VxByteBuf;
import net.xmx.velthoric.physics.body.manager.VxBodyDataStore;
import net.xmx.velthoric.physics.body.persistence.VxSerializedBodyData;
import net.xmx.velthoric.physics.body.type.VxBody;
import org.jetbrains.annotations.Nullable;

public final class VxBodyCodec {
    private VxBodyCodec() {
    }

    public static void serialize(VxBody body, int index, VxBodyDataStore dataStore, VxByteBuf buf) {
        buf.method_10797(body.getPhysicsId());
        buf.method_10814(body.getType().getTypeId().toString());
        buf.method_52940(dataStore.posX[index]);
        buf.method_52940(dataStore.posY[index]);
        buf.method_52940(dataStore.posZ[index]);
        buf.method_52941(dataStore.rotX[index]);
        buf.method_52941(dataStore.rotY[index]);
        buf.method_52941(dataStore.rotZ[index]);
        buf.method_52941(dataStore.rotW[index]);
        buf.method_52941(dataStore.velX[index]);
        buf.method_52941(dataStore.velY[index]);
        buf.method_52941(dataStore.velZ[index]);
        buf.method_52941(dataStore.angVelX[index]);
        buf.method_52941(dataStore.angVelY[index]);
        buf.method_52941(dataStore.angVelZ[index]);
        buf.method_52997(dataStore.motionType[index] != null ? dataStore.motionType[index].ordinal() : EMotionType.Static.ordinal());
        body.writePersistenceData(buf);
    }

    @Nullable
    public static VxSerializedBodyData deserialize(VxByteBuf buf) {
        try {
            UUID id = buf.method_10790();
            class_2960 typeId = class_2960.method_12829((String)buf.method_19772());
            VxTransform transform = new VxTransform();
            transform.fromBuffer(buf);
            Vec3 linearVelocity = new Vec3(buf.readFloat(), buf.readFloat(), buf.readFloat());
            Vec3 angularVelocity = new Vec3(buf.readFloat(), buf.readFloat(), buf.readFloat());
            EMotionType motionType = EMotionType.values()[buf.readByte()];
            if (!linearVelocity.isFinite() || linearVelocity.isNan() || !angularVelocity.isFinite() || angularVelocity.isNan()) {
                VxMainClass.LOGGER.warn("Deserialized invalid velocity for body {}. Resetting to zero.", (Object)id);
                linearVelocity.set(0.0f, 0.0f, 0.0f);
                angularVelocity.set(0.0f, 0.0f, 0.0f);
            }
            VxByteBuf persistenceData = new VxByteBuf(buf.readBytes(buf.readableBytes()));
            return new VxSerializedBodyData(typeId, id, transform, linearVelocity, angularVelocity, motionType, persistenceData);
        }
        catch (Exception e) {
            VxMainClass.LOGGER.error("Failed to deserialize physics body from data", (Throwable)e);
            return null;
        }
    }
}

