/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.body.sync;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.xmx.velthoric.network.VxByteBuf;
import net.xmx.velthoric.physics.body.sync.VxDataAccessor;
import net.xmx.velthoric.physics.body.type.VxBody;
import org.jetbrains.annotations.Nullable;

public class VxSynchronizedData {
    private final Int2ObjectMap<Entry<?>> entries;
    private final EnvType environment;
    private boolean isDirty;

    private VxSynchronizedData(EnvType environment, Int2ObjectMap<Entry<?>> entries) {
        this.environment = environment;
        this.entries = entries;
    }

    public <T> T get(VxDataAccessor<T> accessor) {
        Entry entry = (Entry)this.entries.get(accessor.getId());
        if (entry == null) {
            throw new IllegalArgumentException("Tried to get unregistered data accessor: " + accessor.getId());
        }
        return entry.getValue();
    }

    public <T> void set(VxDataAccessor<T> accessor, T value) {
        Entry<T> entry = this.getEntry(accessor);
        if (entry != null && !Objects.equals(value, entry.getValue())) {
            entry.setValue(value);
            if (this.environment == EnvType.SERVER) {
                entry.setDirty(true);
                this.isDirty = true;
            }
        }
    }

    @Nullable
    private <T> Entry<T> getEntry(VxDataAccessor<T> accessor) {
        return (Entry)this.entries.get(accessor.getId());
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    @Nullable
    public List<Entry<?>> getDirtyEntries() {
        if (!this.isDirty) {
            return null;
        }
        ArrayList dirtyList = new ArrayList();
        for (Entry entry : this.entries.values()) {
            if (!entry.isDirty()) continue;
            dirtyList.add(entry);
        }
        return dirtyList.isEmpty() ? null : dirtyList;
    }

    public List<Entry<?>> getAllEntries() {
        return new ArrayList((Collection<Entry<?>>)this.entries.values());
    }

    public void clearDirty() {
        this.isDirty = false;
        for (Entry entry : this.entries.values()) {
            entry.setDirty(false);
        }
    }

    public static void writeEntries(VxByteBuf buf, List<Entry<?>> entriesToWrite) {
        for (Entry<?> entry : entriesToWrite) {
            VxDataAccessor<?> accessor = entry.getAccessor();
            buf.method_10804(accessor.getId());
            accessor.getSerializer().write(buf, entry.getValue());
        }
        buf.method_10804(255);
    }

    public void readEntries(VxByteBuf buf, VxBody body) {
        int id;
        while ((id = buf.method_10816()) != 255) {
            Entry entry = (Entry)this.entries.get(id);
            if (entry == null) continue;
            this.readEntry(buf, entry);
            body.onSyncedDataUpdated(entry.getAccessor());
        }
    }

    private <T> void readEntry(VxByteBuf buf, Entry<T> entry) {
        T value = entry.getAccessor().getSerializer().read(buf);
        entry.setValue(value);
    }

    public static class Entry<T> {
        private final VxDataAccessor<T> accessor;
        private T value;
        private boolean dirty;

        public Entry(VxDataAccessor<T> accessor, T value) {
            this.accessor = accessor;
            this.value = accessor.getSerializer().copy(value);
        }

        public VxDataAccessor<T> getAccessor() {
            return this.accessor;
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void setDirty(boolean dirty) {
            this.dirty = dirty;
        }
    }

    public static class Builder {
        private final Int2ObjectMap<Entry<?>> entries = new Int2ObjectOpenHashMap();

        public <T> Builder define(VxDataAccessor<T> accessor, T defaultValue) {
            int id = accessor.getId();
            if (this.entries.containsKey(id)) {
                throw new IllegalArgumentException("Duplicate data accessor id: " + id);
            }
            this.entries.put(id, new Entry<T>(accessor, defaultValue));
            return this;
        }

        public VxSynchronizedData build(EnvType environment) {
            return new VxSynchronizedData(environment, (Int2ObjectMap<Entry<?>>)new Int2ObjectOpenHashMap(this.entries));
        }
    }
}

