/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.mounting.entity;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3619;
import net.minecraft.class_5321;
import net.xmx.velthoric.physics.mounting.manager.VxClientMountingManager;
import net.xmx.velthoric.physics.mounting.manager.VxMountingManager;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VxMountingEntity
extends class_1297 {
    private static final class_2940<Optional<UUID>> PHYSICS_ID = class_2945.method_12791(VxMountingEntity.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Optional<UUID>> SEAT_ID = class_2945.method_12791(VxMountingEntity.class, (class_2941)class_2943.field_13313);

    public VxMountingEntity(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
        this.field_5960 = true;
        this.field_23807 = false;
        this.method_5875(true);
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            if (this.method_5685().isEmpty()) {
                this.method_31472();
                return;
            }
            this.restoreMountingLinkIfNeeded();
        }
    }

    private void restoreMountingLinkIfNeeded() {
        class_1297 class_12972 = this.method_31483();
        if (class_12972 instanceof class_3222) {
            VxMountingManager manager;
            VxPhysicsWorld physicsWorld;
            class_3222 player = (class_3222)class_12972;
            Optional<UUID> physicsIdOpt = this.getPhysicsId();
            Optional<UUID> seatIdOpt = this.getSeatId();
            if (physicsIdOpt.isPresent() && seatIdOpt.isPresent() && (physicsWorld = VxPhysicsWorld.get((class_5321<class_1937>)this.method_37908().method_27983())) != null && !(manager = physicsWorld.getMountingManager()).isMounting(player)) {
                manager.restoreMounting(player, physicsIdOpt.get(), seatIdOpt.get());
            }
        }
    }

    public boolean method_5810() {
        return false;
    }

    public void method_5697(class_1297 entity) {
    }

    public boolean method_5675() {
        return false;
    }

    public void method_5784(class_1313 type, class_243 pos) {
    }

    public boolean method_5863() {
        return false;
    }

    public boolean method_30948() {
        return false;
    }

    public boolean method_5679(class_1282 source) {
        return true;
    }

    public boolean method_5753() {
        return true;
    }

    public boolean method_5640(double distance) {
        return false;
    }

    public class_3619 method_5657() {
        return class_3619.field_15975;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(PHYSICS_ID, Optional.empty());
        builder.method_56912(SEAT_ID, Optional.empty());
    }

    public Optional<UUID> getPhysicsId() {
        return (Optional)this.field_6011.method_12789(PHYSICS_ID);
    }

    public Optional<UUID> getSeatId() {
        return (Optional)this.field_6011.method_12789(SEAT_ID);
    }

    public Vector3f getMountPositionOffset() {
        if (this.method_37908().method_8608()) {
            return this.getPhysicsId().flatMap(objId -> this.getSeatId().flatMap(seatId -> VxClientMountingManager.INSTANCE.getSeat((UUID)objId, (UUID)seatId))).map(seat -> new Vector3f((Vector3fc)seat.getRiderOffset())).orElse(new Vector3f());
        }
        class_1297 class_12972 = this.method_31483();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((class_5321<class_1937>)this.method_37908().method_27983());
            if (physicsWorld != null) {
                VxMountingManager mountingManager = physicsWorld.getMountingManager();
                return mountingManager.getSeatForPlayer(player).map(seat -> new Vector3f((Vector3fc)seat.getRiderOffset())).orElse(new Vector3f());
            }
        }
        return new Vector3f();
    }

    public void setMountInfo(UUID physicsId, UUID seatId) {
        this.field_6011.method_12778(PHYSICS_ID, Optional.of(physicsId));
        this.field_6011.method_12778(SEAT_ID, Optional.of(seatId));
    }

    protected void method_5793(class_1297 passenger) {
        super.method_5793(passenger);
        if (!this.method_37908().method_8608() && passenger instanceof class_3222) {
            class_3222 player = (class_3222)passenger;
            VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((class_5321<class_1937>)this.method_37908().method_27983());
            if (physicsWorld != null) {
                physicsWorld.getMountingManager().stopMounting(player);
            }
        }
    }

    public boolean method_5767() {
        return true;
    }

    protected void method_5749(class_2487 compound) {
        if (compound.method_25928("PhysicsId")) {
            this.field_6011.method_12778(PHYSICS_ID, Optional.of(compound.method_25926("PhysicsId")));
        }
        if (compound.method_25928("SeatId")) {
            this.field_6011.method_12778(SEAT_ID, Optional.of(compound.method_25926("SeatId")));
        }
    }

    protected void method_5652(class_2487 compound) {
        this.getPhysicsId().ifPresent(uuid -> compound.method_25927("PhysicsId", uuid));
        this.getSeatId().ifPresent(uuid -> compound.method_25927("SeatId", uuid));
    }
}

