/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.persistence;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.xmx.velthoric.init.VxMainClass;

public final class VxPersistenceManager {
    private static ExecutorService ioWorker;

    private VxPersistenceManager() {
    }

    public static void initialize() {
        if (ioWorker != null && !ioWorker.isShutdown()) {
            return;
        }
        int threadCount = Math.max(2, Math.min(4, Runtime.getRuntime().availableProcessors() / 2));
        ioWorker = Executors.newFixedThreadPool(threadCount, new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "Velthoric-IOWorker-" + this.threadNumber.getAndIncrement());
                t.setDaemon(true);
                t.setPriority(4);
                return t;
            }
        });
        VxMainClass.LOGGER.info("Initialized Velthoric Persistence Manager with {} I/O threads.", (Object)threadCount);
    }

    public static void shutdown() {
        if (ioWorker != null && !ioWorker.isShutdown()) {
            ioWorker.shutdown();
            try {
                if (!ioWorker.awaitTermination(10L, TimeUnit.SECONDS)) {
                    VxMainClass.LOGGER.warn("I/O worker did not terminate in 10 seconds, forcing shutdown.");
                    ioWorker.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                ioWorker.shutdownNow();
                Thread.currentThread().interrupt();
            }
            ioWorker = null;
            VxMainClass.LOGGER.debug("Velthoric Persistence Manager shut down.");
        }
    }

    public static ExecutorService getExecutor() {
        if (ioWorker == null || ioWorker.isShutdown()) {
            VxMainClass.LOGGER.warn("VxPersistenceManager was requested but was not active. Re-initializing...");
            VxPersistenceManager.initialize();
        }
        return ioWorker;
    }
}

