/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.ragdoll;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.SwingTwistConstraintSettings;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EConstraintSpace;
import com.github.stephengold.joltjni.enumerate.ESwingType;
import com.github.stephengold.joltjni.operator.Op;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.util.EnumMap;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.xmx.velthoric.builtin.VxRegisteredBodies;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.body.manager.VxBodyManager;
import net.xmx.velthoric.physics.constraint.manager.VxConstraintManager;
import net.xmx.velthoric.physics.ragdoll.VxBodyPart;
import net.xmx.velthoric.physics.ragdoll.body.VxBodyPartRigidBody;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public class VxRagdollManager {
    private final VxPhysicsWorld world;
    private final VxBodyManager bodyManager;
    private final VxConstraintManager constraintManager;

    public VxRagdollManager(VxPhysicsWorld world) {
        this.world = world;
        this.bodyManager = world.getBodyManager();
        this.constraintManager = world.getConstraintManager();
    }

    public void createHumanoidRagdoll(class_1309 entity, RVec3 spawnPosition) {
        this.world.execute(() -> {
            VxTransform initialTransform = new VxTransform(spawnPosition, Quat.sEulerAngles(0.0f, entity.method_36454() * ((float)Math.PI / 180), 0.0f));
            String skinId = entity instanceof class_1657 ? entity.method_5667().toString() : "";
            EnumMap<VxBodyPart, VxBodyPartRigidBody> parts = new EnumMap<VxBodyPart, VxBodyPartRigidBody>(VxBodyPart.class);
            for (VxBodyPart partType : VxBodyPart.values()) {
                VxBodyPartRigidBody partBody = this.createBodyPart(partType, initialTransform, skinId);
                parts.put(partType, partBody);
            }
            VxBodyPartRigidBody torso = (VxBodyPartRigidBody)parts.get((Object)VxBodyPart.TORSO);
            if (torso == null) {
                return;
            }
            this.createSwingTwistJoint(torso, (VxBodyPartRigidBody)parts.get((Object)VxBodyPart.HEAD), VxBodyPart.HEAD, 80.0f, 120.0f, 80.0f);
            this.createSwingTwistJoint(torso, (VxBodyPartRigidBody)parts.get((Object)VxBodyPart.LEFT_ARM), VxBodyPart.LEFT_ARM, 120.0f, 175.0f, 175.0f);
            this.createSwingTwistJoint(torso, (VxBodyPartRigidBody)parts.get((Object)VxBodyPart.RIGHT_ARM), VxBodyPart.RIGHT_ARM, 120.0f, 175.0f, 175.0f);
            this.createSwingTwistJoint(torso, (VxBodyPartRigidBody)parts.get((Object)VxBodyPart.LEFT_LEG), VxBodyPart.LEFT_LEG, 80.0f, 140.0f, 100.0f);
            this.createSwingTwistJoint(torso, (VxBodyPartRigidBody)parts.get((Object)VxBodyPart.RIGHT_LEG), VxBodyPart.RIGHT_LEG, 80.0f, 140.0f, 100.0f);
        });
    }

    private VxBodyPartRigidBody createBodyPart(VxBodyPart partType, VxTransform initialTransform, String skinId) {
        Vec3 size = partType.getSize();
        Vec3 halfExtents = Op.star(0.5f, (Vec3Arg)size);
        Vec3 partOffsetVec = partType.getAttachmentPointOnTorso();
        RVec3 partOffset = partOffsetVec.toRVec3();
        RVec3 pivotOffset = Op.minus(partType.getLocalPivot().toRVec3());
        RVec3 finalOffset = Op.plus((RVec3Arg)partOffset, (RVec3Arg)pivotOffset);
        finalOffset.rotateInPlace(initialTransform.getRotation());
        RVec3 partPosition = Op.plus((RVec3Arg)initialTransform.getTranslation(), (RVec3Arg)finalOffset);
        VxTransform partTransform = new VxTransform(partPosition, initialTransform.getRotation());
        return this.bodyManager.createRigidBody(VxRegisteredBodies.BODY_PART, partTransform, body -> {
            body.setSyncData(VxBodyPartRigidBody.DATA_HALF_EXTENTS, halfExtents);
            body.setSyncData(VxBodyPartRigidBody.DATA_BODY_PART, partType);
            body.setSyncData(VxBodyPartRigidBody.DATA_SKIN_ID, skinId);
        });
    }

    private void createSwingTwistJoint(VxBodyPartRigidBody torso, VxBodyPartRigidBody limb, VxBodyPart limbType, float twist, float swingY, float swingZ) {
        if (torso == null || limb == null) {
            return;
        }
        try (SwingTwistConstraintSettings settings = new SwingTwistConstraintSettings();){
            settings.setSpace(EConstraintSpace.LocalToBodyCom);
            settings.setSwingType(ESwingType.Pyramid);
            Vec3 pivotOnTorso = limbType.getAttachmentPointOnTorso();
            settings.setPosition1(pivotOnTorso.toRVec3());
            Vec3 pivotOnLimb = limbType.getLocalPivot();
            settings.setPosition2(pivotOnLimb.toRVec3());
            Vec3 primaryAxis = new Vec3(0.0f, 1.0f, 0.0f);
            Vec3 secondaryAxis = new Vec3(1.0f, 0.0f, 0.0f);
            settings.setTwistAxis1(primaryAxis);
            settings.setPlaneAxis1(secondaryAxis);
            settings.setTwistAxis2(primaryAxis);
            settings.setPlaneAxis2(secondaryAxis);
            settings.setTwistMinAngle((float)Math.toRadians(-twist));
            settings.setTwistMaxAngle((float)Math.toRadians(twist));
            settings.setPlaneHalfConeAngle((float)Math.toRadians(swingY));
            settings.setNormalHalfConeAngle((float)Math.toRadians(swingZ));
            this.constraintManager.createConstraint(settings, torso.getPhysicsId(), limb.getPhysicsId());
        }
    }
}

