/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.ragdoll.body;

import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1068;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5602;
import net.minecraft.class_572;
import net.minecraft.class_630;
import net.minecraft.class_640;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.body.client.VxRenderState;
import net.xmx.velthoric.physics.body.client.body.renderer.VxRigidBodyRenderer;
import net.xmx.velthoric.physics.ragdoll.VxBodyPart;
import net.xmx.velthoric.physics.ragdoll.body.VxBodyPartRigidBody;
import org.joml.Quaternionf;

public class VxRagdollBodyPartRenderer
extends VxRigidBodyRenderer<VxBodyPartRigidBody> {
    private class_572<class_1309> model;
    private final Map<VxBodyPart, class_630> partMap = new EnumMap<VxBodyPart, class_630>(VxBodyPart.class);
    private boolean isInitialized = false;

    private void initialize() {
        class_630 root = class_310.method_1551().method_31974().method_32072(class_5602.field_27577);
        this.model = new class_572(root);
        this.partMap.put(VxBodyPart.HEAD, this.model.field_3398);
        this.partMap.put(VxBodyPart.TORSO, this.model.field_3391);
        this.partMap.put(VxBodyPart.LEFT_ARM, this.model.field_27433);
        this.partMap.put(VxBodyPart.RIGHT_ARM, this.model.field_3401);
        this.partMap.put(VxBodyPart.LEFT_LEG, this.model.field_3397);
        this.partMap.put(VxBodyPart.RIGHT_LEG, this.model.field_3392);
        this.isInitialized = true;
    }

    @Override
    public void render(VxBodyPartRigidBody body, class_4587 poseStack, class_4597.class_4598 bufferSource, float partialTicks, int packedLight, VxRenderState renderState) {
        VxBodyPart partType;
        class_630 modelPart;
        if (!this.isInitialized) {
            this.initialize();
        }
        if ((modelPart = this.partMap.get((Object)(partType = body.getSyncData(VxBodyPartRigidBody.DATA_BODY_PART)))) == null) {
            return;
        }
        poseStack.method_22903();
        VxTransform transform = renderState.transform;
        poseStack.method_46416(transform.getTranslation().x(), transform.getTranslation().y(), transform.getTranslation().z());
        poseStack.method_22907(new Quaternionf(transform.getRotation().getX(), transform.getRotation().getY(), transform.getRotation().getZ(), transform.getRotation().getW()));
        float scaleX = body.getSyncData(VxBodyPartRigidBody.DATA_HALF_EXTENTS).getX() * 2.0f / partType.getSize().getX();
        float scaleY = body.getSyncData(VxBodyPartRigidBody.DATA_HALF_EXTENTS).getY() * 2.0f / partType.getSize().getY();
        float scaleZ = body.getSyncData(VxBodyPartRigidBody.DATA_HALF_EXTENTS).getZ() * 2.0f / partType.getSize().getZ();
        poseStack.method_22905(scaleX, scaleY, scaleZ);
        poseStack.method_22905(1.0f, -1.0f, -1.0f);
        poseStack.method_46416(-modelPart.field_3657 / 16.0f, -modelPart.field_3656 / 16.0f, -modelPart.field_3655 / 16.0f);
        switch (partType) {
            case HEAD: {
                poseStack.method_22904(0.0, 0.25, 0.0);
                break;
            }
            case TORSO: 
            case LEFT_LEG: 
            case RIGHT_LEG: {
                poseStack.method_22904(0.0, -0.375, 0.0);
                break;
            }
            case LEFT_ARM: {
                poseStack.method_22904(-0.0625, -0.25, 0.0);
                break;
            }
            case RIGHT_ARM: {
                poseStack.method_22904(0.0625, -0.25, 0.0);
            }
        }
        class_2960 skinTexture = this.getSkinTexture(body);
        class_4588 vertexConsumer = bufferSource.getBuffer(class_1921.method_23572((class_2960)skinTexture));
        modelPart.method_22698(poseStack, vertexConsumer, packedLight, class_4608.field_21444);
        poseStack.method_22909();
    }

    private class_2960 getSkinTexture(VxBodyPartRigidBody body) {
        String skinIdStr = body.getSyncData(VxBodyPartRigidBody.DATA_SKIN_ID);
        if (skinIdStr == null || skinIdStr.isEmpty()) {
            return class_1068.method_4649();
        }
        try {
            class_640 playerInfo;
            UUID playerUuid = UUID.fromString(skinIdStr);
            if (class_310.method_1551().method_1562() != null && (playerInfo = class_310.method_1551().method_1562().method_2871(playerUuid)) != null) {
                return playerInfo.method_52810().comp_1626();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return class_1068.method_4649();
    }
}

