/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.terrain.generation;

import com.github.stephengold.joltjni.BoxShapeSettings;
import com.github.stephengold.joltjni.ShapeRefC;
import com.github.stephengold.joltjni.ShapeResult;
import com.github.stephengold.joltjni.StaticCompoundShapeSettings;
import com.github.stephengold.joltjni.Vec3;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_265;
import net.minecraft.class_3218;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.physics.terrain.cache.VxTerrainShapeCache;
import net.xmx.velthoric.physics.terrain.generation.VxChunkSnapshot;

public final class VxTerrainGenerator
implements AutoCloseable {
    private final VxTerrainShapeCache shapeCache;
    private final Map<Vec3, BoxShapeSettings> boxSettingsCache;
    private static final int BOX_SETTINGS_CACHE_CAPACITY = 256;
    private static final ThreadLocal<Vec3> tempVec3Key = ThreadLocal.withInitial(Vec3::new);

    public VxTerrainGenerator(VxTerrainShapeCache shapeCache) {
        this.shapeCache = shapeCache;
        this.boxSettingsCache = new LinkedHashMap<Vec3, BoxShapeSettings>(256, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Vec3, BoxShapeSettings> eldest) {
                boolean shouldRemove;
                boolean bl = shouldRemove = this.size() > 256;
                if (shouldRemove && eldest.getValue() != null) {
                    eldest.getValue().close();
                }
                return shouldRemove;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShapeRefC generateShape(class_3218 level, VxChunkSnapshot snapshot) {
        int contentHash = snapshot.hashCode();
        ShapeRefC cachedShape = this.shapeCache.get(contentHash);
        if (cachedShape != null) {
            return cachedShape;
        }
        if (snapshot.shapes().isEmpty()) {
            return null;
        }
        try (StaticCompoundShapeSettings compoundSettings = new StaticCompoundShapeSettings();){
            ShapeRefC shapeRefC;
            block25: {
                ShapeResult result;
                block23: {
                    ShapeRefC shapeRefC2;
                    block24: {
                        boolean hasShapes = false;
                        Vec3 halfExtentsKey = tempVec3Key.get();
                        for (VxChunkSnapshot.ShapeInfo info : snapshot.shapes()) {
                            class_2338 worldPos = snapshot.pos().getOrigin().method_10081((class_2382)info.localPos());
                            class_265 voxelShape = info.state().method_26220((class_1922)level, worldPos);
                            for (class_238 aabb : voxelShape.method_1090()) {
                                BoxShapeSettings boxSettings;
                                float hx = (float)(aabb.method_17939() / 2.0);
                                float hy = (float)(aabb.method_17940() / 2.0);
                                float hz = (float)(aabb.method_17941() / 2.0);
                                if (hx <= 0.001f || hy <= 0.001f || hz <= 0.001f) continue;
                                halfExtentsKey.set(hx, hy, hz);
                                Map<Vec3, BoxShapeSettings> map = this.boxSettingsCache;
                                synchronized (map) {
                                    boxSettings = this.boxSettingsCache.get(halfExtentsKey);
                                    if (boxSettings == null) {
                                        Vec3 newKey = new Vec3(hx, hy, hz);
                                        boxSettings = new BoxShapeSettings(newKey, 0.0f);
                                        this.boxSettingsCache.put(newKey, boxSettings);
                                    }
                                }
                                float cx = (float)((double)info.localPos().method_10263() + aabb.field_1323 + (double)hx);
                                float cy = (float)((double)info.localPos().method_10264() + aabb.field_1322 + (double)hy);
                                float cz = (float)((double)info.localPos().method_10260() + aabb.field_1321 + (double)hz);
                                compoundSettings.addShape(cx, cy, cz, boxSettings);
                                hasShapes = true;
                            }
                        }
                        if (!hasShapes) {
                            Iterator<VxChunkSnapshot.ShapeInfo> iterator = null;
                            return iterator;
                        }
                        result = compoundSettings.create();
                        try {
                            if (!result.isValid()) break block23;
                            ShapeRefC newShape = result.get();
                            this.shapeCache.put(contentHash, newShape);
                            shapeRefC2 = newShape.getPtr().toRefC();
                            if (result == null) break block24;
                        }
                        catch (Throwable throwable) {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        result.close();
                    }
                    return shapeRefC2;
                }
                VxMainClass.LOGGER.error("Failed to create StaticCompoundShape for {}: {}", (Object)snapshot.pos(), (Object)result.getError());
                shapeRefC = null;
                if (result == null) break block25;
                result.close();
            }
            return shapeRefC;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Map<Vec3, BoxShapeSettings> map = this.boxSettingsCache;
        synchronized (map) {
            for (BoxShapeSettings settings : this.boxSettingsCache.values()) {
                settings.close();
            }
            this.boxSettingsCache.clear();
        }
    }
}

