/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.terrain.management;

import com.github.stephengold.joltjni.Body;
import com.github.stephengold.joltjni.BodyCreationSettings;
import com.github.stephengold.joltjni.BodyInterface;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.ShapeRefC;
import com.github.stephengold.joltjni.enumerate.EActivation;
import com.github.stephengold.joltjni.enumerate.EMotionType;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import net.minecraft.class_1937;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.physics.terrain.VxSectionPos;
import net.xmx.velthoric.physics.terrain.generation.VxChunkSnapshot;
import net.xmx.velthoric.physics.terrain.generation.VxTerrainGenerator;
import net.xmx.velthoric.physics.terrain.job.VxTerrainJobSystem;
import net.xmx.velthoric.physics.terrain.storage.VxChunkDataStore;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public final class VxTerrainManager {
    public static final int STATE_UNLOADED = 0;
    public static final int STATE_LOADING_SCHEDULED = 1;
    public static final int STATE_GENERATING_SHAPE = 2;
    public static final int STATE_READY_INACTIVE = 3;
    public static final int STATE_READY_ACTIVE = 4;
    public static final int STATE_REMOVING = 5;
    public static final int STATE_AIR_CHUNK = 6;
    private final VxPhysicsWorld physicsWorld;
    private final class_3218 level;
    private final VxTerrainGenerator terrainGenerator;
    private final VxChunkDataStore chunkDataStore;
    private final VxTerrainJobSystem jobSystem;

    public VxTerrainManager(VxPhysicsWorld physicsWorld, class_3218 level, VxTerrainGenerator terrainGenerator, VxChunkDataStore chunkDataStore, VxTerrainJobSystem jobSystem) {
        this.physicsWorld = physicsWorld;
        this.level = level;
        this.terrainGenerator = terrainGenerator;
        this.chunkDataStore = chunkDataStore;
        this.jobSystem = jobSystem;
    }

    public void requestChunk(VxSectionPos pos) {
        int index = this.chunkDataStore.addChunk(pos);
        if (this.chunkDataStore.incrementAndGetRefCount(index) == 1) {
            this.scheduleShapeGeneration(pos, index, true);
        }
    }

    public void releaseChunk(VxSectionPos pos) {
        Integer index = this.chunkDataStore.getIndexForPos(pos);
        if (index != null && this.chunkDataStore.decrementAndGetRefCount(index) == 0) {
            this.unloadChunkPhysicsInternal(pos);
        }
    }

    public void rebuildChunk(VxSectionPos pos) {
        Integer index = this.chunkDataStore.getIndexForPos(pos);
        if (index != null) {
            this.scheduleShapeGeneration(pos, index, false);
        }
    }

    public void prioritizeChunk(VxSectionPos pos) {
        Integer index = this.chunkDataStore.getIndexForPos(pos);
        if (index != null && (this.isPlaceholder(index) || !this.isReady(index))) {
            this.scheduleShapeGeneration(pos, index, false);
        }
    }

    public void activateChunk(VxSectionPos pos) {
        Integer index = this.chunkDataStore.getIndexForPos(pos);
        if (index == null) {
            return;
        }
        if (this.chunkDataStore.getState(index) == 6) {
            return;
        }
        if (this.chunkDataStore.getBodyId(index) != 0 && this.chunkDataStore.getState(index) == 3) {
            this.chunkDataStore.setState(index, 4);
            this.physicsWorld.execute(() -> {
                BodyInterface bodyInterface = this.physicsWorld.getPhysicsSystem().getBodyInterface();
                int bodyId = this.chunkDataStore.getBodyId(index);
                if (bodyInterface != null && bodyId != 0 && !bodyInterface.isAdded(bodyId)) {
                    bodyInterface.addBody(bodyId, EActivation.Activate);
                }
            });
        }
        if (this.isPlaceholder(index) && this.chunkDataStore.getBodyId(index) != 0) {
            this.scheduleShapeGeneration(pos, index, false);
        }
    }

    public void deactivateChunk(VxSectionPos pos) {
        Integer index = this.chunkDataStore.getIndexForPos(pos);
        if (index == null) {
            return;
        }
        if (this.chunkDataStore.getBodyId(index) != 0 && this.chunkDataStore.getState(index) == 4) {
            this.chunkDataStore.setState(index, 3);
            this.physicsWorld.execute(() -> {
                BodyInterface bodyInterface = this.physicsWorld.getPhysicsSystem().getBodyInterface();
                int bodyId = this.chunkDataStore.getBodyId(index);
                if (bodyInterface != null && bodyId != 0 && bodyInterface.isAdded(bodyId)) {
                    bodyInterface.removeBody(bodyId);
                }
            });
        }
    }

    private void scheduleShapeGeneration(VxSectionPos pos, int index, boolean isInitialBuild) {
        if (this.jobSystem.isShutdown()) {
            return;
        }
        int version = this.chunkDataStore.scheduleForGeneration(index);
        if (version == -1) {
            return;
        }
        this.level.method_8503().execute(() -> {
            if (this.chunkDataStore.isVersionStale(index, version)) {
                return;
            }
            class_2818 chunk = this.level.method_14178().method_12126(pos.x(), pos.z(), false);
            if (chunk == null) {
                this.chunkDataStore.setState(index, 0);
                return;
            }
            VxChunkSnapshot snapshot = VxChunkSnapshot.snapshotFromChunk((class_1937)this.level, chunk, pos);
            if (this.chunkDataStore.getState(index) == 1) {
                this.chunkDataStore.setState(index, 2);
                this.jobSystem.submit(() -> this.processShapeGenerationOnWorker(pos, index, version, snapshot, isInitialBuild));
            }
        });
    }

    private void processShapeGenerationOnWorker(VxSectionPos pos, int index, int version, VxChunkSnapshot snapshot, boolean isInitialBuild) {
        if (this.chunkDataStore.isVersionStale(index, version)) {
            if (this.chunkDataStore.getState(index) == 2) {
                this.chunkDataStore.setState(index, 0);
            }
            return;
        }
        try {
            ShapeRefC generatedShape = this.terrainGenerator.generateShape(this.level, snapshot);
            this.physicsWorld.execute(() -> this.applyGeneratedShape(pos, index, version, generatedShape, isInitialBuild));
        }
        catch (Exception e) {
            VxMainClass.LOGGER.error("Exception during terrain shape generation for {}", (Object)pos, (Object)e);
            this.chunkDataStore.setState(index, 0);
        }
    }

    private void applyGeneratedShape(VxSectionPos pos, int index, int version, ShapeRefC shape, boolean isInitialBuild) {
        if (this.chunkDataStore.isVersionStale(index, version) || this.chunkDataStore.getState(index) == 5) {
            if (shape != null) {
                shape.close();
            }
            if (this.chunkDataStore.getState(index) != 5) {
                this.chunkDataStore.setState(index, 0);
            }
            return;
        }
        boolean wasActive = this.chunkDataStore.getState(index) == 4;
        BodyInterface bodyInterface = this.physicsWorld.getPhysicsSystem().getBodyInterface();
        if (bodyInterface == null) {
            if (shape != null) {
                shape.close();
            }
            this.chunkDataStore.setState(index, 0);
            return;
        }
        int bodyId = this.chunkDataStore.getBodyId(index);
        if (bodyId != 0) {
            if (shape != null) {
                bodyInterface.setShape(bodyId, shape, true, EActivation.DontActivate);
                this.chunkDataStore.setShape(index, shape);
                this.chunkDataStore.setState(index, wasActive ? 4 : 3);
            } else {
                this.removeBodyAndShape(index, bodyInterface);
                this.chunkDataStore.setState(index, 6);
            }
        } else if (shape != null) {
            RVec3 position = new RVec3(pos.getOrigin().method_10263(), pos.getOrigin().method_10264(), pos.getOrigin().method_10260());
            try (BodyCreationSettings bcs = new BodyCreationSettings(shape, (RVec3Arg)position, (QuatArg)Quat.sIdentity(), EMotionType.Static, 3);){
                Body body = bodyInterface.createBody(bcs);
                if (body != null) {
                    body.setFriction(0.75f);
                    this.chunkDataStore.setBodyId(index, body.getId());
                    this.chunkDataStore.setShape(index, shape);
                    this.chunkDataStore.setState(index, wasActive ? 4 : 3);
                }
                VxMainClass.LOGGER.error("Failed to create terrain body for chunk {}", (Object)pos);
                shape.close();
                this.chunkDataStore.setState(index, 0);
            }
        } else {
            this.chunkDataStore.setState(index, 6);
        }
        this.chunkDataStore.setPlaceholder(index, isInitialBuild);
        if (wasActive) {
            this.activateChunk(pos);
        }
    }

    private void unloadChunkPhysicsInternal(VxSectionPos pos) {
        Integer index = this.chunkDataStore.getIndexForPos(pos);
        if (index == null) {
            return;
        }
        this.chunkDataStore.setState(index, 5);
        this.physicsWorld.execute(() -> {
            this.removeBodyAndShape(index, this.physicsWorld.getPhysicsSystem().getBodyInterface());
            this.chunkDataStore.removeChunk(pos);
        });
    }

    private void removeBodyAndShape(int index, BodyInterface bodyInterface) {
        int bodyId = this.chunkDataStore.getBodyId(index);
        if (bodyId != 0 && bodyInterface != null) {
            if (bodyInterface.isAdded(bodyId)) {
                bodyInterface.removeBody(bodyId);
            }
            bodyInterface.destroyBody(bodyId);
        }
        this.chunkDataStore.setBodyId(index, 0);
        this.chunkDataStore.setShape(index, null);
    }

    public void cleanupAllBodies() {
        BodyInterface bi = this.physicsWorld.getPhysicsSystem().getBodyInterface();
        if (bi != null) {
            this.chunkDataStore.getManagedPositions().forEach(pos -> {
                Integer index = this.chunkDataStore.getIndexForPos((VxSectionPos)pos);
                if (index != null) {
                    this.removeBodyAndShape(index, bi);
                }
            });
        }
    }

    public boolean isManaged(VxSectionPos pos) {
        return this.chunkDataStore.getIndexForPos(pos) != null;
    }

    public boolean isReady(VxSectionPos pos) {
        Integer index = this.chunkDataStore.getIndexForPos(pos);
        return index != null && this.isReady(index);
    }

    private boolean isReady(int index) {
        int state = this.chunkDataStore.getState(index);
        return state == 4 || state == 3 || state == 6;
    }

    public boolean isPlaceholder(VxSectionPos pos) {
        Integer index = this.chunkDataStore.getIndexForPos(pos);
        if (index == null) {
            return true;
        }
        return this.isPlaceholder(index);
    }

    private boolean isPlaceholder(int index) {
        return this.chunkDataStore.isPlaceholder(index);
    }
}

