/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.terrain.management;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_3218;
import net.minecraft.class_4076;
import net.xmx.velthoric.physics.body.manager.VxBodyDataStore;
import net.xmx.velthoric.physics.body.type.VxBody;
import net.xmx.velthoric.physics.terrain.VxSectionPos;
import net.xmx.velthoric.physics.terrain.management.VxTerrainManager;
import net.xmx.velthoric.physics.terrain.storage.VxChunkDataStore;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public final class VxTerrainTracker {
    private final VxPhysicsWorld physicsWorld;
    private final VxTerrainManager terrainManager;
    private final VxChunkDataStore chunkDataStore;
    private final class_3218 level;
    private final VxBodyDataStore bodyDataStore;
    private Set<VxSectionPos> previouslyRequiredChunks = new HashSet<VxSectionPos>();
    private static final int GRID_CELL_SIZE_IN_CHUNKS = 4;
    private static final int ACTIVATION_RADIUS_CHUNKS = 1;
    private static final int PRELOAD_RADIUS_CHUNKS = 3;
    private static final float PREDICTION_SECONDS = 0.5f;

    public VxTerrainTracker(VxPhysicsWorld physicsWorld, VxTerrainManager terrainManager, VxChunkDataStore chunkDataStore, class_3218 level) {
        this.physicsWorld = physicsWorld;
        this.terrainManager = terrainManager;
        this.chunkDataStore = chunkDataStore;
        this.level = level;
        this.bodyDataStore = physicsWorld.getBodyManager().getDataStore();
    }

    public void update() {
        ArrayList<VxBody> currentBodies = new ArrayList<VxBody>(this.physicsWorld.getBodyManager().getAllBodies());
        if (currentBodies.isEmpty()) {
            this.releaseAllChunks();
            this.deactivateAllChunks();
            return;
        }
        Set<VxSectionPos> currentlyRequiredChunks = this.calculateRequiredPreloadSet(currentBodies);
        for (VxSectionPos pos : currentlyRequiredChunks) {
            if (this.previouslyRequiredChunks.contains(pos)) continue;
            this.terrainManager.requestChunk(pos);
        }
        for (VxSectionPos pos : this.previouslyRequiredChunks) {
            if (currentlyRequiredChunks.contains(pos)) continue;
            this.terrainManager.releaseChunk(pos);
        }
        this.previouslyRequiredChunks = currentlyRequiredChunks;
        this.updateChunkActivation(currentBodies);
    }

    private Set<VxSectionPos> calculateRequiredPreloadSet(List<VxBody> allBodies) {
        HashMap<Long, List> bodyClusters = new HashMap<Long, List>();
        for (VxBody body : allBodies) {
            int dataIndex = body.getDataStoreIndex();
            if (dataIndex == -1) continue;
            VxSectionPos bodySectionPos = VxSectionPos.fromWorldSpace(this.bodyDataStore.posX[dataIndex], this.bodyDataStore.posY[dataIndex], this.bodyDataStore.posZ[dataIndex]);
            int cellX = bodySectionPos.x() / 4;
            int cellY = bodySectionPos.y() / 4;
            int cellZ = bodySectionPos.z() / 4;
            long cellKey = class_4076.method_18685((int)cellX, (int)cellY, (int)cellZ);
            bodyClusters.computeIfAbsent(cellKey, k -> new ArrayList()).add(body);
        }
        HashSet<VxSectionPos> requiredChunks = new HashSet<VxSectionPos>();
        for (List cluster : bodyClusters.values()) {
            if (cluster.isEmpty()) continue;
            float minX = Float.POSITIVE_INFINITY;
            float minY = Float.POSITIVE_INFINITY;
            float minZ = Float.POSITIVE_INFINITY;
            float maxX = Float.NEGATIVE_INFINITY;
            float maxY = Float.NEGATIVE_INFINITY;
            float maxZ = Float.NEGATIVE_INFINITY;
            boolean clusterHasValidBodies = false;
            for (VxBody body : cluster) {
                int dataIndex = body.getDataStoreIndex();
                if (dataIndex == -1) continue;
                clusterHasValidBodies = true;
                minX = Math.min(minX, this.bodyDataStore.aabbMinX[dataIndex]);
                minY = Math.min(minY, this.bodyDataStore.aabbMinY[dataIndex]);
                minZ = Math.min(minZ, this.bodyDataStore.aabbMinZ[dataIndex]);
                maxX = Math.max(maxX, this.bodyDataStore.aabbMaxX[dataIndex]);
                maxY = Math.max(maxY, this.bodyDataStore.aabbMaxY[dataIndex]);
                maxZ = Math.max(maxZ, this.bodyDataStore.aabbMaxZ[dataIndex]);
                float velX = this.bodyDataStore.velX[dataIndex];
                float velY = this.bodyDataStore.velY[dataIndex];
                float velZ = this.bodyDataStore.velZ[dataIndex];
                if (!(Math.abs(velX) > 0.01f) && !(Math.abs(velY) > 0.01f) && !(Math.abs(velZ) > 0.01f)) continue;
                float predMinX = this.bodyDataStore.aabbMinX[dataIndex] + velX * 0.5f;
                float predMinY = this.bodyDataStore.aabbMinY[dataIndex] + velY * 0.5f;
                float predMinZ = this.bodyDataStore.aabbMinZ[dataIndex] + velZ * 0.5f;
                float predMaxX = this.bodyDataStore.aabbMaxX[dataIndex] + velX * 0.5f;
                float predMaxY = this.bodyDataStore.aabbMaxY[dataIndex] + velY * 0.5f;
                float predMaxZ = this.bodyDataStore.aabbMaxZ[dataIndex] + velZ * 0.5f;
                minX = Math.min(minX, predMinX);
                minY = Math.min(minY, predMinY);
                minZ = Math.min(minZ, predMinZ);
                maxX = Math.max(maxX, predMaxX);
                maxY = Math.max(maxY, predMaxY);
                maxZ = Math.max(maxZ, predMaxZ);
            }
            if (!clusterHasValidBodies) continue;
            this.forEachSectionInBox(minX, minY, minZ, maxX, maxY, maxZ, 3, requiredChunks);
        }
        return requiredChunks;
    }

    private void updateChunkActivation(List<VxBody> allBodies) {
        HashSet<VxSectionPos> requiredActiveSet = new HashSet<VxSectionPos>();
        for (VxBody body : allBodies) {
            int dataIndex = body.getDataStoreIndex();
            if (dataIndex == -1 || !this.bodyDataStore.isActive[dataIndex]) continue;
            float minX = this.bodyDataStore.aabbMinX[dataIndex];
            float minY = this.bodyDataStore.aabbMinY[dataIndex];
            float minZ = this.bodyDataStore.aabbMinZ[dataIndex];
            float maxX = this.bodyDataStore.aabbMaxX[dataIndex];
            float maxY = this.bodyDataStore.aabbMaxY[dataIndex];
            float maxZ = this.bodyDataStore.aabbMaxZ[dataIndex];
            this.forEachSectionInBox(minX, minY, minZ, maxX, maxY, maxZ, 1, requiredActiveSet);
        }
        requiredActiveSet.forEach(pos -> this.terrainManager.prioritizeChunk((VxSectionPos)pos));
        Set currentlyActive = this.chunkDataStore.getActiveIndices().stream().filter(index -> this.chunkDataStore.getState((int)index) == 4).map(this.chunkDataStore::getPosForIndex).filter(Objects::nonNull).collect(Collectors.toSet());
        for (VxSectionPos pos2 : currentlyActive) {
            if (requiredActiveSet.contains(pos2)) continue;
            this.terrainManager.deactivateChunk(pos2);
        }
        for (VxSectionPos pos3 : requiredActiveSet) {
            if (currentlyActive.contains(pos3)) continue;
            this.terrainManager.activateChunk(pos3);
        }
    }

    private void forEachSectionInBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, int radiusInChunks, Set<VxSectionPos> outChunks) {
        int minSectionX = class_4076.method_42615((double)minX) - radiusInChunks;
        int minSectionY = class_4076.method_42615((double)minY) - radiusInChunks;
        int minSectionZ = class_4076.method_42615((double)minZ) - radiusInChunks;
        int maxSectionX = class_4076.method_42615((double)maxX) + radiusInChunks;
        int maxSectionY = class_4076.method_42615((double)maxY) + radiusInChunks;
        int maxSectionZ = class_4076.method_42615((double)maxZ) + radiusInChunks;
        int worldMinY = this.level.method_31607() >> 4;
        int worldMaxY = this.level.method_31600() >> 4;
        for (int y = minSectionY; y <= maxSectionY; ++y) {
            if (y < worldMinY || y >= worldMaxY) continue;
            for (int z = minSectionZ; z <= maxSectionZ; ++z) {
                for (int x = minSectionX; x <= maxSectionX; ++x) {
                    outChunks.add(new VxSectionPos(x, y, z));
                }
            }
        }
    }

    private void releaseAllChunks() {
        if (this.previouslyRequiredChunks.isEmpty()) {
            return;
        }
        for (VxSectionPos pos : this.previouslyRequiredChunks) {
            this.terrainManager.releaseChunk(pos);
        }
        this.previouslyRequiredChunks.clear();
    }

    private void deactivateAllChunks() {
        this.chunkDataStore.getActiveIndices().stream().map(this.chunkDataStore::getPosForIndex).filter(Objects::nonNull).forEach(this.terrainManager::deactivateChunk);
    }

    public void clear() {
        this.releaseAllChunks();
    }
}

