/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.vehicle.sync;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.xmx.velthoric.network.VxPacketHandler;
import net.xmx.velthoric.physics.body.manager.VxBodyManager;
import net.xmx.velthoric.physics.body.type.VxBody;
import net.xmx.velthoric.physics.vehicle.VxVehicle;
import net.xmx.velthoric.physics.vehicle.sync.S2CVehicleStatePacket;
import net.xmx.velthoric.physics.vehicle.wheel.VxWheel;

public class VxVehicleNetworkDispatcher {
    public void dispatchUpdates(class_3218 level, VxBodyManager manager, Map<Integer, Set<class_3222>> bodyTrackers) {
        ArrayList<VxVehicle> dirtyVehicles = new ArrayList<VxVehicle>();
        for (VxBody body : manager.getAllBodies()) {
            VxVehicle vehicle;
            if (!(body instanceof VxVehicle) || !(vehicle = (VxVehicle)body).isVehicleStateDirty()) continue;
            dirtyVehicles.add(vehicle);
            vehicle.clearVehicleStateDirty();
        }
        if (dirtyVehicles.isEmpty()) {
            return;
        }
        level.method_8503().execute(() -> {
            for (VxVehicle vehicle : dirtyVehicles) {
                Set trackers = (Set)bodyTrackers.get(vehicle.getNetworkId());
                if (trackers == null || trackers.isEmpty()) continue;
                float speedKmh = vehicle.getSpeedKmh();
                List<VxWheel> wheels = vehicle.getWheels();
                int wheelCount = wheels.size();
                float[] rotations = new float[wheelCount];
                float[] steers = new float[wheelCount];
                float[] suspensions = new float[wheelCount];
                if (wheelCount > 0) {
                    for (int i = 0; i < wheelCount; ++i) {
                        VxWheel wheel = wheels.get(i);
                        rotations[i] = wheel.getRotationAngle();
                        steers[i] = wheel.getSteerAngle();
                        suspensions[i] = wheel.getSuspensionLength();
                    }
                }
                S2CVehicleStatePacket packet = new S2CVehicleStatePacket(vehicle.getNetworkId(), speedKmh, rotations, steers, suspensions);
                for (class_3222 player : trackers) {
                    VxPacketHandler.sendToPlayer(packet, player);
                }
            }
        });
    }
}

