/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.CollideShapeCollector;
import com.github.stephengold.joltjni.CollideShapeResult;
import java.util.ArrayList;
import java.util.List;

public class AllHitCollideShapeCollector
extends CollideShapeCollector {
    public AllHitCollideShapeCollector() {
        long collectorVa = AllHitCollideShapeCollector.createDefault();
        this.setVirtualAddressAsOwner(collectorVa);
    }

    public int countHits() {
        long collectorVa = this.va();
        int result = AllHitCollideShapeCollector.countHits(collectorVa);
        return result;
    }

    public CollideShapeResult get(int index) {
        long collectorVa = this.va();
        long hitVa = AllHitCollideShapeCollector.getHit(collectorVa, index);
        CollideShapeResult result = new CollideShapeResult(this, hitVa);
        return result;
    }

    public List<CollideShapeResult> getHits() {
        long collectorVa = this.va();
        int numHits = AllHitCollideShapeCollector.countHits(collectorVa);
        ArrayList<CollideShapeResult> result = new ArrayList<CollideShapeResult>(numHits);
        for (int i = 0; i < numHits; ++i) {
            long hitVa = AllHitCollideShapeCollector.getHit(collectorVa, i);
            CollideShapeResult hit = new CollideShapeResult(this, hitVa);
            result.add(hit);
        }
        return result;
    }

    public void sort() {
        long collectorVa = this.va();
        AllHitCollideShapeCollector.sort(collectorVa);
    }

    @Override
    public void reset() {
        long collectorVa = this.va();
        AllHitCollideShapeCollector.reset(collectorVa);
    }

    private static native int countHits(long var0);

    private static native long createDefault();

    private static native long getHit(long var0, int var2);

    private static native void reset(long var0);

    private static native void sort(long var0);
}

